/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.relevancy.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.smartactivitystream.relevancy.ActivityRelevancyService;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceEntity;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceId;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceStatsEntity;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceStatsReport;

@Path(value="/smartactivity/relevancy")
@Produces(value={"application/json"})
public class RESTActivityRelevancyService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(RESTActivityRelevancyService.class);
    protected final ActivityRelevancyService activityRelevancyService;

    public RESTActivityRelevancyService(ActivityRelevancyService activityRelevancyService) {
        this.activityRelevancyService = activityRelevancyService;
    }

    @POST
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Path(value="/{userId}/{activityId}")
    public Response saveRelevance(@PathParam(value="userId") String userId, @PathParam(value="activityId") String activityId, RelevanceEntity relevanceEntity) {
        if (this.isUserAllowed(relevanceEntity.getUserId())) {
            if (!relevanceEntity.getUserId().equals(userId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"error\" : \"Bad request\", \"message\" : \"User ID doesn't match\" }").build();
            }
            if (!relevanceEntity.getActivityId().equals(activityId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"error\" : \"Bad request\", \"message\" : \"Activity ID doesn't match\" }").build();
            }
            this.activityRelevancyService.saveRelevance(relevanceEntity);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"error\" : \"Forbidden\", \"message\" : \"Cannot set relevancy for other users\" }").build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/{userId}/{activityId}")
    @Produces(value={"application/json"})
    public Response getRelevance(@PathParam(value="userId") String userId, @PathParam(value="activityId") String activityId) {
        if (this.isUserAllowed(userId)) {
            RelevanceEntity relevanceEntity = this.activityRelevancyService.findById(new RelevanceId(userId, activityId));
            if (relevanceEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{ \"error\" : \"Not found\", \"message\" : \"Relevancy not found\" }").build();
            }
            try {
                String prettyJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)relevanceEntity);
                return Response.ok().entity((Object)prettyJson).build();
            }
            catch (JsonProcessingException e) {
                LOG.warn((Object)("Error serializing relevancy to pretty JSON: " + e.getMessage()));
                return Response.ok().entity((Object)relevanceEntity).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"error\" : \"Forbidden\", \"message\" : \"Cannot get relevancy for other users\" }").build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/stats")
    @Produces(value={"application/json"})
    public Response getStats(@QueryParam(value="since_days") String sinceDaysStr) {
        try {
            int sinceDays;
            SimpleDateFormat dateFormat;
            block9: {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (sinceDaysStr != null && sinceDaysStr.length() > 0) {
                    try {
                        sinceDays = Integer.parseInt(sinceDaysStr);
                        if (sinceDays <= 0) {
                            LOG.warn((Object)("Wrong paramater since_days '" + sinceDaysStr + "': should be greater of zero"));
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"error\" : \"Client error\", \"message\" : \"Parameter 'since_days' should be greater of zero\" }").build();
                        }
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)("Wrong parameter format since_days '" + sinceDaysStr + "': " + e.getMessage()));
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"error\" : \"Client error\", \"message\" : \"Parameter 'since_days' has wrong format\" }").build();
                    }
                }
                sinceDays = 90;
            }
            Calendar since = Calendar.getInstance();
            since.add(5, -sinceDays);
            since.set(11, 0);
            since.set(12, 0);
            since.set(13, 0);
            since.set(14, 1);
            List<RelevanceStatsEntity> userStats = this.activityRelevancyService.findUserStats(since.getTime());
            if (userStats == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{ \"error\" : \"Not found\", \"message\" : \"User stats not found\" }").build();
            }
            long totalCount = this.activityRelevancyService.getRelevanciesCount();
            RelevanceStatsReport report = new RelevanceStatsReport(totalCount, userStats);
            report.setDescription("Statistics since " + dateFormat.format(since.getTime()));
            try {
                String prettyJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)report);
                return Response.ok().entity((Object)prettyJson).build();
            }
            catch (JsonProcessingException e) {
                LOG.warn((Object)("Error serializing stats report to pretty JSON: " + e.getMessage()));
                return Response.ok().entity((Object)report).build();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Error getting activity relevancy statistics: ", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{ \"error\" : \"Internal error\", \"message\" : \"" + e.getMessage() + "\" }")).build();
        }
    }

    private boolean isUserAllowed(String userId) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserId = conversationState.getIdentity().getUserId();
            return currentUserId.equals(userId);
        }
        return false;
    }
}

