/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.stats.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.smartactivitystream.stats.ActivityStatsService;

@Path(value="/smartactivity/stats")
@Produces(value={"application/json"})
public class RESTActivityStatsService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(RESTActivityStatsService.class);
    protected final ActivityStatsService activityStatsService;

    public RESTActivityStatsService(ActivityStatsService activityStatsService) {
        this.activityStatsService = activityStatsService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/save")
    @Produces(value={"application/json"})
    public Response saveStats() {
        try {
            if (this.activityStatsService.isTrackersEnabled()) {
                this.activityStatsService.saveTrackers();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)"{ \"success\" : \"Saved\", \"message\" : \"Trackers saved\" }").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"error\" : \"Not enabled\", \"message\" : \"Trackers not enabled\" }").build();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error saving activity statistics: ", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{ \"error\" : \"Internal error\", \"message\" : \"" + e.getMessage() + "\" }")).build();
        }
    }
}

