/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.smartactivitystream.cometd.CometdSmartActivityService;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class ContextInfo {
    private final String containerName;
    private final String cometdPath;
    private final String cometdToken;
    private final String userId;

    public static final ContextInfo getCurrentContext(String userId) {
        ExoContainer exo = ExoContainerContext.getCurrentContainer();
        CometdSmartActivityService cometdService = (CometdSmartActivityService)exo.getComponentInstanceOfType(CometdSmartActivityService.class);
        ContextInfo context = cometdService != null ? new ContextInfo(exo.getContext().getName(), userId, cometdService.getCometdServerPath(), cometdService.getUserToken(userId)) : new ContextInfo(exo.getContext().getName(), userId, null, null);
        return context;
    }

    private ContextInfo(String containerName, String userId, String cometdPath, String cometdToken) {
        this.containerName = containerName;
        this.cometdPath = cometdPath;
        this.cometdToken = cometdToken;
        this.userId = userId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCometdPath() {
        return this.cometdPath;
    }

    public String getCometdToken() {
        return this.cometdToken;
    }

    public String getUserId() {
        return this.userId;
    }

    public String asJSON() throws JsonException {
        JsonGeneratorImpl gen = new JsonGeneratorImpl();
        return gen.createJsonObject((Object)this).toString();
    }
}

