/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.stats.domain;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.smartactivitystream.stats.domain.FocusId;

@Entity(name="SmartActivityFocus")
@ExoEntity
@Table(name="ST_ACTIVITY_FOCUS")
@IdClass(value=FocusId.class)
@NamedQueries(value={@NamedQuery(name="SmartActivityFocus.findTotalCount", query="SELECT COUNT(f.activityId) FROM SmartActivityFocus f"), @NamedQuery(name="SmartActivityFocus.findAllFocus", query="SELECT f FROM SmartActivityFocus f WHERE f.userId = :userId AND f.activityId = :activityId ORDER BY f.startTime ASC"), @NamedQuery(name="SmartActivityFocus.findFocusAfter", query="SELECT f FROM SmartActivityFocus f WHERE f.userId = :userId AND f.activityId = :activityId AND f.startTime >= :startTimeAfter ORDER BY f.startTime DESC")})
public class ActivityFocusEntity
implements Externalizable {
    private static final Long NULL_LONG = new Long(-1L);
    public static final String TRACKER_VERSION = "1.0";
    @Id
    @Column(name="USER_ID", nullable=false)
    protected String userId;
    @Id
    @Column(name="ACTIVITY_ID", nullable=false)
    protected String activityId;
    @Id
    @Column(name="START_TIME", nullable=false)
    protected Long startTime;
    @Column(name="STOP_TIME", nullable=false)
    protected Long stopTime;
    @Column(name="TOTAL_SHOWN", nullable=false)
    protected Long totalShown;
    @Column(name="CONTENT_SHOWN")
    protected Long contentShown;
    @Column(name="CONVO_SHOWN")
    protected Long convoShown;
    @Column(name="CONTENT_HITS")
    protected Long contentHits;
    @Column(name="CONVO_HITS")
    protected Long convoHits;
    @Column(name="APP_HITS")
    protected Long appHits;
    @Column(name="PROFILE_HITS")
    protected Long profileHits;
    @Column(name="LINK_HITS")
    protected Long linkHits;
    @Column(name="TRACKER_VERSION", nullable=false)
    protected String trackerVersion;
    private transient int hashCode;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.hashCode = 0;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
        this.hashCode = 0;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
        this.hashCode = 0;
    }

    public Long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Long stopTime) {
        this.stopTime = stopTime;
        this.hashCode = 0;
    }

    public Long getTotalShown() {
        return this.totalShown;
    }

    public void setTotalShown(Long totalShow) {
        this.totalShown = totalShow;
        this.hashCode = 0;
    }

    public Long getContentShown() {
        return this.contentShown;
    }

    public void setContentShown(Long contentShow) {
        this.contentShown = contentShow;
        this.hashCode = 0;
    }

    public Long getConvoShown() {
        return this.convoShown;
    }

    public void setConvoShown(Long convoShow) {
        this.convoShown = convoShow;
        this.hashCode = 0;
    }

    public Long getContentHits() {
        return this.contentHits;
    }

    public void setContentHits(Long contentHits) {
        this.contentHits = contentHits;
        this.hashCode = 0;
    }

    public Long getConvoHits() {
        return this.convoHits;
    }

    public void setConvoHits(Long convoHits) {
        this.convoHits = convoHits;
        this.hashCode = 0;
    }

    public Long getAppHits() {
        return this.appHits;
    }

    public void setAppHits(Long appHits) {
        this.appHits = appHits;
        this.hashCode = 0;
    }

    public Long getProfileHits() {
        return this.profileHits;
    }

    public void setProfileHits(Long profileHits) {
        this.profileHits = profileHits;
        this.hashCode = 0;
    }

    public Long getLinkHits() {
        return this.linkHits;
    }

    public void setLinkHits(Long linkHits) {
        this.linkHits = linkHits;
        this.hashCode = 0;
    }

    public String getTrackerVersion() {
        return this.trackerVersion;
    }

    public void setTrackerVersion(String trackerVersion) {
        this.trackerVersion = trackerVersion;
        this.hashCode = 0;
    }

    @Transient
    public FocusId getId() {
        return new FocusId(this.userId, this.activityId, this.startTime);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.userId);
        out.writeUTF(this.activityId);
        out.writeUTF(this.trackerVersion);
        out.writeLong(this.startTime);
        out.writeLong(this.stopTime);
        out.writeLong(this.totalShown);
        out.writeLong(this.contentShown != null ? this.contentShown : NULL_LONG);
        out.writeLong(this.convoShown != null ? this.convoShown : NULL_LONG);
        out.writeLong(this.contentHits != null ? this.contentHits : NULL_LONG);
        out.writeLong(this.convoHits != null ? this.convoHits : NULL_LONG);
        out.writeLong(this.appHits != null ? this.appHits : NULL_LONG);
        out.writeLong(this.profileHits != null ? this.profileHits : NULL_LONG);
        out.writeLong(this.linkHits != null ? this.linkHits : NULL_LONG);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashCode = 0;
        this.userId = in.readUTF();
        this.activityId = in.readUTF();
        this.trackerVersion = in.readUTF();
        this.startTime = in.readLong();
        this.stopTime = in.readLong();
        this.totalShown = in.readLong();
        Long l = in.readLong();
        this.contentShown = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.convoShown = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.contentHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.convoHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.appHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.profileHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.linkHits = l != NULL_LONG ? l : null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.activityId == null ? 0 : this.activityId.hashCode());
            result = 31 * result + (this.appHits == null ? 0 : this.appHits.hashCode());
            result = 31 * result + (this.contentHits == null ? 0 : this.contentHits.hashCode());
            result = 31 * result + (this.contentShown == null ? 0 : this.contentShown.hashCode());
            result = 31 * result + (this.convoHits == null ? 0 : this.convoHits.hashCode());
            result = 31 * result + (this.convoShown == null ? 0 : this.convoShown.hashCode());
            result = 31 * result + (this.linkHits == null ? 0 : this.linkHits.hashCode());
            result = 31 * result + (this.profileHits == null ? 0 : this.profileHits.hashCode());
            result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
            result = 31 * result + (this.stopTime == null ? 0 : this.stopTime.hashCode());
            result = 31 * result + (this.totalShown == null ? 0 : this.totalShown.hashCode());
            result = 31 * result + (this.trackerVersion == null ? 0 : this.trackerVersion.hashCode());
            this.hashCode = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && ActivityFocusEntity.class.isAssignableFrom(obj.getClass())) {
            ActivityFocusEntity other = (ActivityFocusEntity)ActivityFocusEntity.class.cast(obj);
            if (this.activityId == null ? other.activityId != null : !this.activityId.equals(other.activityId)) {
                return false;
            }
            if (this.appHits == null ? other.appHits != null : !this.appHits.equals(other.appHits)) {
                return false;
            }
            if (this.contentHits == null ? other.contentHits != null : !this.contentHits.equals(other.contentHits)) {
                return false;
            }
            if (this.contentShown == null ? other.contentShown != null : !this.contentShown.equals(other.contentShown)) {
                return false;
            }
            if (this.convoHits == null ? other.convoHits != null : !this.convoHits.equals(other.convoHits)) {
                return false;
            }
            if (this.convoShown == null ? other.convoShown != null : !this.convoShown.equals(other.convoShown)) {
                return false;
            }
            if (this.linkHits == null ? other.linkHits != null : !this.linkHits.equals(other.linkHits)) {
                return false;
            }
            if (this.profileHits == null ? other.profileHits != null : !this.profileHits.equals(other.profileHits)) {
                return false;
            }
            if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
                return false;
            }
            if (this.stopTime == null ? other.stopTime != null : !this.stopTime.equals(other.stopTime)) {
                return false;
            }
            if (this.totalShown == null ? other.totalShown != null : !this.totalShown.equals(other.totalShown)) {
                return false;
            }
            if (this.trackerVersion == null ? other.trackerVersion != null : !this.trackerVersion.equals(other.trackerVersion)) {
                return false;
            }
            return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append('-');
        s.append(this.userId);
        s.append('@');
        s.append(this.activityId);
        s.append('-');
        s.append(this.startTime);
        s.append('-');
        s.append(this.stopTime);
        return s.toString();
    }
}

