/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.portlet;

import javax.portlet.GenericPortlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.smartactivitystream.stats.ActivityStatsService;
import org.exoplatform.smartactivitystream.stats.ContextInfo;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;

public class SmartActivityStreamPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(SmartActivityStreamPortlet.class);

    protected void doView(RenderRequest request, RenderResponse response) {
        ActivityStatsService statsService = (ActivityStatsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityStatsService.class);
        if (statsService != null && statsService.isTrackersEnabled()) {
            String contextJson;
            try {
                contextJson = ContextInfo.getCurrentContext((String)request.getRemoteUser()).asJSON();
            }
            catch (JsonException e) {
                LOG.error((Object)"Error converting context to JSON", (Throwable)e);
                contextJson = null;
            }
            JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
            js.require("SHARED/smartactivity", "smartactivity").addScripts("smartactivity.init(" + contextJson + ");");
        }
    }
}

