/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.addons.storage.dao.ActivityDAO;
import org.exoplatform.social.addons.storage.dao.jpa.query.AStreamQueryBuilder;
import org.exoplatform.social.addons.storage.entity.ActivityEntity;
import org.exoplatform.social.addons.storage.entity.StreamItemEntity_;
import org.exoplatform.social.addons.storage.entity.StreamType;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.ActivityStorageException;

public class ActivityDAOImpl
extends GenericDAOJPAImpl<ActivityEntity, Long>
implements ActivityDAO {
    @Override
    public List<ActivityEntity> getActivities(Identity owner, Identity viewer, long offset, long limit) throws ActivityStorageException {
        TypedQuery query;
        if (viewer != null && !viewer.getId().equals(owner.getId())) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwnerAndProviderId", ActivityEntity.class);
            query.setParameter("providerId", (Object)"organization");
        } else {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwner", ActivityEntity.class);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.parseLong(owner.getId()));
        query.setParameter("owner", ids);
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    @Override
    public List<String> getUserIdsActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        return this.convertActivityEntitiesToIds(AStreamQueryBuilder.builder().owner(owner).offset(offset).limit(limit).buildId().getResultList());
    }

    @Override
    public List<ActivityEntity> getActivityFeed(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityFeed", ActivityEntity.class);
        query.setParameter("owners", owners);
        query.setParameter("ownerid", (Object)ownerId);
        query.setParameter("connStatus", (Object)Relationship.Type.CONFIRMED);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<String> getActivityIdsFeed(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        return this.convertActivityEntitiesToIds(AStreamQueryBuilder.builder().owner(ownerIdentity).myIdentity(ownerIdentity).memberOfSpaceIds(spaceIds).offset(offset).limit(limit).buildId().getResultList());
    }

    @Override
    public int getNumberOfActivitesOnActivityFeed(Identity ownerIdentity, List<String> spaceIds) {
        return ((Long)AStreamQueryBuilder.builder().owner(ownerIdentity).myIdentity(ownerIdentity).memberOfSpaceIds(spaceIds).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getNewerOnActivityFeed(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityFeed", ActivityEntity.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        query.setParameter("ownerid", (Object)ownerId);
        query.setParameter("connStatus", (Object)Relationship.Type.CONFIRMED);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        return ((Long)AStreamQueryBuilder.builder().owner(ownerIdentity).myIdentity(ownerIdentity).memberOfSpaceIds(spaceIds).newer(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getOlderOnActivityFeed(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityFeed", ActivityEntity.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        query.setParameter("ownerid", (Object)ownerId);
        query.setParameter("connStatus", (Object)Relationship.Type.CONFIRMED);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        return ((Long)AStreamQueryBuilder.builder().owner(ownerIdentity).myIdentity(ownerIdentity).memberOfSpaceIds(spaceIds).older(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getUserActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        return this.getOwnerActivities(Arrays.asList(owner.getId()), -1L, -1L, offset, limit);
    }

    @Override
    public int getNumberOfUserActivities(Identity ownerIdentity) {
        return ((Long)AStreamQueryBuilder.builder().owner(ownerIdentity).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getNewerOnUserActivities(Identity ownerIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(ownerIdentity.getId()), sinceTime, -1L, 0L, limit);
    }

    @Override
    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, long sinceTime) {
        return ((Long)AStreamQueryBuilder.builder().owner(ownerIdentity).newer(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getOlderOnUserActivities(Identity ownerIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(ownerIdentity.getId()), -1L, sinceTime, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, long sinceTime) {
        return ((Long)AStreamQueryBuilder.builder().owner(ownerIdentity).older(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getSpaceActivities(Identity spaceOwner, long offset, long limit) throws ActivityStorageException {
        return this.getOwnerActivities(Arrays.asList(spaceOwner.getId()), -1L, -1L, offset, limit);
    }

    @Override
    public List<String> getSpaceActivityIds(Identity spaceOwner, long offset, long limit) throws ActivityStorageException {
        return this.convertActivityEntitiesToIds(AStreamQueryBuilder.builder().owner(spaceOwner).offset(offset).limit(limit).buildId().getResultList());
    }

    @Override
    public int getNumberOfSpaceActivities(Identity spaceIdentity) {
        return ((Long)AStreamQueryBuilder.builder().owner(spaceIdentity).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getNewerOnSpaceActivities(Identity spaceIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(spaceIdentity.getId()), sinceTime, -1L, 0L, limit);
    }

    @Override
    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, long sinceTime) {
        return ((Long)AStreamQueryBuilder.builder().owner(spaceIdentity).newer(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getOlderOnSpaceActivities(Identity spaceIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(spaceIdentity.getId()), -1L, sinceTime, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnSpaceActivities(Identity spaceIdentity, long sinceTime) {
        return ((Long)AStreamQueryBuilder.builder().owner(spaceIdentity).older(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getUserSpacesActivities(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, -1L, -1L, offset, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getUserSpacesActivityIds(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.convertActivityEntitiesToIds(AStreamQueryBuilder.builder().memberOfSpaceIds(spaceIds).offset(offset).limit(limit).buildId().getResultList());
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfUserSpacesActivities(Identity ownerIdentity, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return ((Long)AStreamQueryBuilder.builder().memberOfSpaceIds(spaceIds).buildCount().getSingleResult()).intValue();
        }
        return 0;
    }

    @Override
    public List<ActivityEntity> getNewerOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, sinceTime, -1L, 0L, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return ((Long)AStreamQueryBuilder.builder().memberOfSpaceIds(spaceIds).newer(sinceTime).buildCount().getSingleResult()).intValue();
        }
        return 0;
    }

    @Override
    public List<ActivityEntity> getOlderOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, -1L, sinceTime, 0L, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return ((Long)AStreamQueryBuilder.builder().memberOfSpaceIds(spaceIds).older(sinceTime).buildCount().getSingleResult()).intValue();
        }
        return 0;
    }

    @Override
    public List<ActivityEntity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityOfConnection", ActivityEntity.class);
        query.setParameter("ownerid", (Object)Long.parseLong(ownerIdentity.getId()));
        query.setParameter("connStatus", (Object)Relationship.Type.CONFIRMED);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<String> getActivityIdsOfConnections(Identity ownerIdentity, int offset, int limit) {
        return this.convertActivityEntitiesToIds(AStreamQueryBuilder.builder().myIdentity(ownerIdentity).offset(offset).limit(limit).buildId().getResultList());
    }

    @Override
    public int getNumberOfActivitiesOfConnections(Identity ownerIdentity) {
        return ((Long)AStreamQueryBuilder.builder().myIdentity(ownerIdentity).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getNewerOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityOfConnection", ActivityEntity.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("ownerid", (Object)Long.parseLong(ownerIdentity.getId()));
        query.setParameter("connStatus", (Object)Relationship.Type.CONFIRMED);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0L) {
            query.setFirstResult(0);
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    @Override
    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime) {
        return ((Long)AStreamQueryBuilder.builder().myIdentity(ownerIdentity).newer(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getOlderOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityOfConnection", ActivityEntity.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("ownerid", (Object)Long.parseLong(ownerIdentity.getId()));
        query.setParameter("connStatus", (Object)Relationship.Type.CONFIRMED);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime) {
        return ((Long)AStreamQueryBuilder.builder().myIdentity(ownerIdentity).older(sinceTime).buildCount().getSingleResult()).intValue();
    }

    @Override
    public List<ActivityEntity> getActivitiesByPoster(Identity posterIdentity, int offset, int limit, String ... activityTypes) {
        return AStreamQueryBuilder.builder().owner(posterIdentity).activityTypes(activityTypes).offset(offset).limit(limit).buildGetActivitiesByPoster().getResultList();
    }

    @Override
    public int getNumberOfActivitiesByPoster(Identity posterIdentity, String ... activityTypes) {
        return ((Long)AStreamQueryBuilder.builder().owner(posterIdentity).activityTypes(activityTypes).buildActivitiesByPosterCount().getSingleResult()).intValue();
    }

    private List<String> convertActivityEntitiesToIds(List<Tuple> list) {
        LinkedList<String> ids = new LinkedList<String>();
        if (list == null) {
            return ids;
        }
        for (Tuple t : list) {
            ids.add(String.valueOf(t.get(StreamItemEntity_.activityId.getName())));
        }
        return ids;
    }

    @Override
    public long getNumberOfComments(long activityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.numberCommentsOfActivity", Long.class);
        query.setParameter("activityId", (Object)activityId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<ActivityEntity> getComments(long activityId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getNewerComments(long activityId, Date sinceTime, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findNewerCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        query.setParameter("sinceTime", (Object)(sinceTime != null ? sinceTime.getTime() : 0L));
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getOlderComments(long activityId, Date sinceTime, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findOlderCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        query.setParameter("sinceTime", (Object)(sinceTime != null ? sinceTime.getTime() : 0L));
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public ActivityEntity getParentActivity(long commentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getParentActivity", ActivityEntity.class);
        query.setParameter("commentId", (Object)commentId);
        query.setMaxResults(1);
        try {
            return (ActivityEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<ActivityEntity> getAllActivities() {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getAllActivities", ActivityEntity.class);
        return query.getResultList();
    }

    public List<ActivityEntity> getOwnerActivities(List<String> owners, long newerTime, long olderTime, long offset, long limit) throws ActivityStorageException {
        TypedQuery query;
        if (newerTime > 0L) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityByOwner", ActivityEntity.class);
            query.setParameter("sinceTime", (Object)newerTime);
        } else if (olderTime > 0L) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityByOwner", ActivityEntity.class);
            query.setParameter("sinceTime", (Object)olderTime);
        } else {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwner", ActivityEntity.class);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : owners) {
            ids.add(Long.parseLong(id));
        }
        query.setParameter("owner", ids);
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }
}

