/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.updater;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.persistence.EntityManager;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.addons.updater.MigrationContext;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProviderEntity;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.query.JCRProperties;

public abstract class AbstractMigrationService<T>
extends AbstractStorage {
    protected Log LOG;
    protected static final String LIMIT_THRESHOLD_KEY = "LIMIT_THRESHOLD";
    protected final IdentityStorage identityStorage;
    protected final EventManager<T, String> eventManager;
    protected final EntityManagerService entityManagerService;
    protected boolean forkStop = false;
    protected int LIMIT_THRESHOLD = 100;
    protected String process = "";
    protected int lastPercent = 0;
    private static String identityQuery = null;
    private static String spaceIdentityQuery = null;
    protected long numberFailed = 0L;
    protected long numberUserIdentities = 0L;
    protected long numberSpaceIdentities = 0L;

    public AbstractMigrationService(InitParams initParams, IdentityStorageImpl identityStorage, EventManager<T, String> eventManager, EntityManagerService entityManagerService) {
        this.identityStorage = identityStorage;
        this.eventManager = eventManager;
        this.entityManagerService = entityManagerService;
        this.LOG = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    public void addMigrationListener(Listener<T, String> listener) {
        this.eventManager.addEventListener(this.getListenerKey(), listener);
    }

    public void removeMigrationListener(Listener<T, String> listener) {
        this.eventManager.removeEventListener(this.getListenerKey(), listener);
    }

    protected void broadcastListener(T t, String newId) {
        List listeners = this.eventManager.getEventListeners(this.getListenerKey());
        for (Listener listener : listeners) {
            try {
                Event event = new Event(this.getListenerKey(), t, (Object)newId);
                listener.onEvent(event);
            }
            catch (Exception e) {
                this.LOG.warn((Object)("Activity is still migrated, but failed to broadcastListener for listener: " + listener.getName()), (Throwable)e);
            }
        }
    }

    public void start() {
        this.forkStop = false;
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.beforeMigration();
            this.doMigration();
            this.afterMigration();
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed to run migration data from JCR to Mysql.", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
        this.forkStop = true;
    }

    protected Map<String, IdentityEntity> getAllIdentityEntity(String providerId) {
        ProviderEntity providerEntity;
        try {
            providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get(providerId);
        }
        catch (Exception ex) {
            this.lifeCycle.getProviderRoot().set(null);
            providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get(providerId);
        }
        return providerEntity != null ? providerEntity.getIdentities() : new HashMap();
    }

    protected void processLog(String msg, int size, int count) {
        double percent;
        int n = size = size <= 0 ? 1 : size;
        if (count == 1) {
            this.process = "=";
            this.lastPercent = 0;
        }
        if ((int)(percent = (double)(100 * count / size)) > this.lastPercent && (int)percent % 2 == 0) {
            this.process = this.process + "=";
            this.lastPercent = (int)percent;
        }
        this.LOG.info((Object)String.format(msg + ":[%s> %s%%]", this.process, percent));
    }

    protected NodeIterator getIdentityNodes() {
        ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("organization");
        if (providerEntity == null) {
            MigrationContext.setDone(true);
            return null;
        }
        String identityQuery = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ").append(JCRProperties.path.getName()).append(" LIKE '").append(((ProviderEntity)this.getProviderRoot().getProviders().get("organization")).getPath()).append("/").append("%").append("'").toString();
        return this.nodes(identityQuery);
    }

    public List<String> getIdentityIds(int offset, int limit) {
        NodeIterator iter = this.getIdentityNodes(offset, limit);
        if (iter == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        while (iter.hasNext()) {
            try {
                results.add(iter.nextNode().getUUID());
            }
            catch (RepositoryException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.LOG.info((Object)("Number of Identity Ids: " + results.size()));
        return results;
    }

    protected NodeIterator getIdentityNodes(long offset, long limit) {
        ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("organization");
        if (providerEntity == null) {
            return null;
        }
        if (identityQuery == null) {
            identityQuery = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ").append(JCRProperties.path.getName()).append(" LIKE '").append(((ProviderEntity)this.getProviderRoot().getProviders().get("organization")).getPath()).append("/").append("%").append("'").toString();
        }
        return this.nodes(identityQuery, offset, limit);
    }

    protected long getNumberUserIdentities() {
        if (this.numberUserIdentities == 0L) {
            ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("organization");
            if (providerEntity == null) {
                return 0L;
            }
            this.numberUserIdentities = providerEntity.getIdentities().size();
        }
        return this.numberUserIdentities;
    }

    protected NodeIterator getSpaceIdentityNodes(long offset, long limit) {
        if (spaceIdentityQuery == null) {
            ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("space");
            spaceIdentityQuery = providerEntity != null ? new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ").append(JCRProperties.path.getName()).append(" LIKE '").append(providerEntity.getPath()).append("/").append("%").append("'").toString() : null;
        }
        return this.nodes(spaceIdentityQuery, offset, limit);
    }

    protected long getNumberSpaceIdentities() {
        if (this.numberSpaceIdentities == 0L) {
            ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("space");
            if (providerEntity == null) {
                return 0L;
            }
            this.numberSpaceIdentities = providerEntity.getIdentities().size();
        }
        return this.numberSpaceIdentities;
    }

    protected NodeIterator getSpaceIdentityNodes() {
        if (spaceIdentityQuery == null) {
            ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("space");
            if (providerEntity != null) {
                spaceIdentityQuery = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ").append(JCRProperties.path.getName()).append(" LIKE '").append(providerEntity.getPath()).append("/").append("%").append("'").toString();
            } else {
                spaceIdentityQuery = null;
                return null;
            }
        }
        return this.nodes(spaceIdentityQuery);
    }

    protected int getInteger(InitParams params, String key, int defaultValue) {
        try {
            return Integer.valueOf(params.getValueParam(key).getValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getString(InitParams params, String key, String defaultValue) {
        try {
            return params.getValueParam(key).getValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected boolean startTx() {
        EntityManager em = this.entityManagerService.getEntityManager();
        if (!em.getTransaction().isActive()) {
            em.getTransaction().begin();
            this.LOG.debug((Object)"started new transaction");
            return true;
        }
        return false;
    }

    public void endTx(boolean requestClose) {
        EntityManager em = this.entityManagerService.getEntityManager();
        try {
            if (requestClose && em.getTransaction().isActive()) {
                em.getTransaction().commit();
                this.LOG.debug((Object)"commited transaction");
            }
        }
        catch (RuntimeException e) {
            this.LOG.error((Object)("Failed to commit to DB::" + e.getMessage()), (Throwable)e);
            em.getTransaction().rollback();
        }
    }

    protected abstract void beforeMigration() throws Exception;

    public abstract void doMigration() throws Exception;

    protected abstract void afterMigration() throws Exception;

    public abstract void doRemove() throws Exception;

    protected abstract String getListenerKey();
}

