/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.updater.listener;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class UserProfileActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(UserProfileActivityUpdaterListener.class);
    private static final String PROFILE_ACTIVITY_TYPE = "USER_PROFILE_ACTIVITY";

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String newActivityId = (String)event.getData();
        IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
        if (PROFILE_ACTIVITY_TYPE.equals(activity.getType())) {
            Identity identity = identityStorage.findIdentity("organization", activity.getStreamOwner());
            identityStorage.updateProfileActivityId(identity, newActivityId, Profile.AttachedActivityType.USER);
            LOG.info((Object)String.format("Migration the profile activity '%s' with old id's %s and new id's %s", activity.getTitle(), activity.getId(), newActivityId));
        }
    }
}

