/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.social.addons.search.ExtendProfileFilter;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity_;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;
import org.exoplatform.social.addons.storage.entity.IdentityEntity_;
import org.exoplatform.social.addons.storage.entity.ProfileExperienceEntity_;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;

public class ProfileQueryBuilder {
    ExtendProfileFilter filter;

    private ProfileQueryBuilder() {
    }

    public static ProfileQueryBuilder builder() {
        return new ProfileQueryBuilder();
    }

    public ProfileQueryBuilder withFilter(ExtendProfileFilter filter) {
        this.filter = filter;
        return this;
    }

    public TypedQuery[] build(EntityManager em) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(IdentityEntity.class);
        Root identity = query.from(IdentityEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.filter != null) {
            String all;
            char c;
            MapJoin properties;
            String val;
            String name;
            if (this.filter.isForceLoadProfile()) {
                // empty if block
            }
            if (this.filter.isExcludeDeleted()) {
                predicates.add(cb.isFalse((Expression)identity.get(IdentityEntity_.deleted)));
            }
            if (this.filter.isExcludeDisabled()) {
                predicates.add(cb.isTrue((Expression)identity.get(IdentityEntity_.enabled)));
            }
            if (this.filter.getIdentityIds() != null && this.filter.getIdentityIds().size() > 0) {
                predicates.add(identity.get(IdentityEntity_.id).in(this.filter.getIdentityIds()));
            }
            if (this.filter.getProviderId() != null && !this.filter.getProviderId().isEmpty()) {
                predicates.add(cb.equal((Expression)identity.get(IdentityEntity_.providerId), (Object)this.filter.getProviderId()));
            }
            if (this.filter.getConnection() != null) {
                Object incoming;
                Identity owner = this.filter.getConnection();
                Long ownerId = Long.valueOf(owner.getId());
                Relationship.Type status = this.filter.getConnectionStatus();
                if (status == Relationship.Type.INCOMING) {
                    ListJoin outgoing = identity.join(IdentityEntity_.outgoingConnections, JoinType.INNER);
                    predicates.add(cb.and((Expression)cb.equal((Expression)outgoing.get(ConnectionEntity_.receiver), (Object)ownerId), (Expression)cb.equal((Expression)outgoing.get(ConnectionEntity_.status), (Object)Relationship.Type.PENDING)));
                } else if (status == Relationship.Type.OUTGOING) {
                    incoming = identity.join(IdentityEntity_.incomingConnections, JoinType.INNER);
                    predicates.add(cb.and((Expression)cb.equal((Expression)incoming.get(ConnectionEntity_.sender), (Object)ownerId), (Expression)cb.equal((Expression)incoming.get(ConnectionEntity_.status), (Object)Relationship.Type.PENDING)));
                } else {
                    incoming = identity.join(IdentityEntity_.incomingConnections, JoinType.LEFT);
                    ListJoin outgoing = identity.join(IdentityEntity_.outgoingConnections, JoinType.LEFT);
                    Predicate out = cb.equal((Expression)outgoing.get(ConnectionEntity_.receiver), (Object)ownerId);
                    if (status != null) {
                        out = cb.and((Expression)out, (Expression)cb.equal((Expression)outgoing.get(ConnectionEntity_.status), (Object)status));
                    }
                    Predicate in = cb.equal((Expression)incoming.get(ConnectionEntity_.sender), (Object)ownerId);
                    if (status != null) {
                        in = cb.and((Expression)in, (Expression)cb.equal((Expression)incoming.get(ConnectionEntity_.status), (Object)status));
                    }
                    predicates.add(cb.or((Expression)in, (Expression)out));
                }
            }
            ListJoin experience = identity.join(IdentityEntity_.experiences, JoinType.LEFT);
            List<Identity> excludes = this.filter.getExcludedIdentityList();
            if (excludes != null && excludes.size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(excludes.size());
                for (Identity id : excludes) {
                    ids.add(Long.parseLong(id.getId()));
                }
                predicates.add(cb.not((Expression)identity.get(IdentityEntity_.id).in(ids)));
            }
            if ((name = this.filter.getName()) != null && !name.isEmpty()) {
                name = this.processLikeString(name);
                MapJoin properties2 = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                predicates.add(cb.and((Expression)cb.like(cb.lower((Expression)properties2.value()), name), (Expression)properties2.key().in(Arrays.asList("firstName", "lastName", "fullName"))));
            }
            if ((val = this.filter.getPosition()) != null && !val.isEmpty()) {
                val = this.processLikeString(val);
                Predicate[] p = new Predicate[2];
                properties = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                p[1] = cb.and((Expression)cb.like(cb.lower((Expression)properties.value()), val), (Expression)cb.equal((Expression)properties.key(), (Object)"position"));
                p[0] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.position)), val);
                predicates.add(cb.or(p));
            }
            if ((val = this.filter.getSkills()) != null && !val.isEmpty()) {
                val = this.processLikeString(val);
                predicates.add(cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.skills)), val));
            }
            if ((val = this.filter.getCompany()) != null && !val.isEmpty()) {
                val = this.processLikeString(val);
                predicates.add(cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.company)), val));
            }
            if ((c = this.filter.getFirstCharacterOfName()) != '\u0000') {
                val = Character.toLowerCase(c) + "%";
                properties = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                predicates.add(cb.and((Expression)cb.equal((Expression)properties.key(), (Object)"lastName"), (Expression)cb.like(cb.lower((Expression)properties.value()), val)));
            }
            if ((all = this.filter.getAll()) != null && !all.trim().isEmpty()) {
                all = this.processLikeString(all).toLowerCase();
                Predicate[] p = new Predicate[5];
                MapJoin properties3 = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                p[0] = cb.and((Expression)cb.like(cb.lower((Expression)properties3.value()), name), (Expression)properties3.key().in(Arrays.asList("firstName", "lastName", "fullName")));
                p[1] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.position)), all);
                p[2] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.skills)), all);
                p[3] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.company)), all);
                p[4] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.description)), all);
                predicates.add(cb.or(p));
            }
        }
        Predicate[] pds = predicates.toArray(new Predicate[predicates.size()]);
        query.select((Selection)cb.countDistinct((Expression)identity)).where(pds);
        TypedQuery count = em.createQuery(query);
        query.select((Selection)identity).distinct(true).where(pds);
        TypedQuery select = em.createQuery(query);
        return new TypedQuery[]{select, count};
    }

    private String processLikeString(String s) {
        return "%" + s.toLowerCase() + "%";
    }
}

