/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.addons.storage.dao.ConnectionDAO;
import org.exoplatform.social.addons.storage.dao.jpa.ConnectionDAOImpl$AjcClosure1;
import org.exoplatform.social.addons.storage.dao.jpa.query.RelationshipQueryBuilder;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;

public class ConnectionDAOImpl
extends GenericDAOJPAImpl<ConnectionEntity, Long>
implements ConnectionDAO {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @ExoTransactional
    public long count(Identity identity, Relationship.Type status) {
        Identity identity2 = identity;
        Relationship.Type type = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)identity2, (Object)type);
        Object[] objectArray = new Object[]{this, identity2, type, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new ConnectionDAOImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Override
    public ConnectionEntity getConnection(Identity identity1, Identity identity2) {
        TypedQuery<ConnectionEntity> query = RelationshipQueryBuilder.builder().sender(identity1).receiver(identity2).buildSingleRelationship();
        try {
            return (ConnectionEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            return (ConnectionEntity)query.getResultList().get(0);
        }
    }

    @Override
    public ConnectionEntity getConnection(Long sender, Long reciver) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocConnection.findConnectionBySenderAndReceiver", ConnectionEntity.class);
        query.setParameter("sender", (Object)sender);
        query.setParameter("reciver", (Object)reciver);
        query.setMaxResults(1);
        try {
            return (ConnectionEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<ConnectionEntity> getConnections(Identity identity, Relationship.Type status, long offset, long limit) {
        Long ownerId = Long.valueOf(identity.getId());
        String queryName = null;
        if (status == null || status == Relationship.Type.ALL) {
            queryName = "SocConnection.getConnectionsWithoutStatus";
        } else {
            if (status == Relationship.Type.INCOMING) {
                return this.getSenders(ownerId, Relationship.Type.PENDING, (int)offset, (int)limit);
            }
            if (status == Relationship.Type.OUTGOING) {
                return this.getReceivers(ownerId, Relationship.Type.PENDING, (int)offset, (int)limit);
            }
            queryName = "SocConnection.getConnectionsWithStatus";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, ConnectionEntity.class);
        query.setParameter("identityId", (Object)ownerId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ConnectionEntity> getConnections(Identity sender, Identity receiver, Relationship.Type status) {
        return RelationshipQueryBuilder.builder().sender(sender).receiver(receiver).status(status).build().getResultList();
    }

    @Override
    public int getConnectionsCount(Identity identity, Relationship.Type status) {
        Long ownerId = Long.valueOf(identity.getId());
        String queryName = null;
        if (status == null || status == Relationship.Type.ALL) {
            queryName = "SocConnection.countConnectionsWithoutStatus";
        } else {
            if (status == Relationship.Type.INCOMING) {
                return this.countSenderId(ownerId, Relationship.Type.PENDING).intValue();
            }
            if (status == Relationship.Type.OUTGOING) {
                return this.countReceiverId(ownerId, Relationship.Type.PENDING).intValue();
            }
            queryName = "SocConnection.countConnectionsWithStatus";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)ownerId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<ConnectionEntity> getLastConnections(Identity identity, int limit) {
        return RelationshipQueryBuilder.builder().owner(identity).status(Relationship.Type.CONFIRMED).offset(0L).limit(limit).buildLastConnections().getResultList();
    }

    @Override
    public List<ConnectionEntity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit) {
        return RelationshipQueryBuilder.builder().owner(existingIdentity).status(type).offset(0L).limit(limit).filter(profileFilter).buildFilter().getResultList();
    }

    @Override
    public int getConnectionsByFilterCount(Identity identity, ProfileFilter profileFilter, Relationship.Type type) {
        return ((Long)RelationshipQueryBuilder.builder().owner(identity).status(type).filter(profileFilter).buildFilterCount().getSingleResult()).intValue();
    }

    @Override
    public List<Long> getSenderIds(long receiverId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getSenderIdsByReceiverWithoutStatus" : "SocConnection.getSenderIdsByReceiverWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<Long> getReceiverIds(long senderId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getReceiverIdsBySenderWithoutStatus" : "SocConnection.getReceiverIdsBySenderWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)senderId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    private Long countSenderId(long receiverId, Relationship.Type status) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.countSenderByReceiverWithoutStatus" : "SocConnection.countSenderByReceiverWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        return (Long)query.getSingleResult();
    }

    private Long countReceiverId(long sender, Relationship.Type status) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.countReceiverBySenderWithoutStatus" : "SocConnection.countReceiverBySenderWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)sender);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        return (Long)query.getSingleResult();
    }

    private List<ConnectionEntity> getReceivers(long receiverId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getReceiverBySenderWithoutStatus" : "SocConnection.getReceiverBySenderWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, ConnectionEntity.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List receiversList = query.getResultList();
        return receiversList;
    }

    private List<ConnectionEntity> getSenders(long receiverId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getSenderByReceiverWithoutStatus" : "SocConnection.getSenderByReceiverWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, ConnectionEntity.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    static {
        ConnectionDAOImpl.ajc$preClinit();
    }

    static /* synthetic */ long count_aroundBody0(ConnectionDAOImpl ajc$this, Identity identity, Relationship.Type status, JoinPoint joinPoint) {
        return (Long)RelationshipQueryBuilder.builder().owner(identity).status(status).buildCount().getSingleResult();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConnectionDAOImpl.java", ConnectionDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "count", "org.exoplatform.social.addons.storage.dao.jpa.ConnectionDAOImpl", "org.exoplatform.social.core.identity.model.Identity:org.exoplatform.social.core.relationship.model.Relationship$Type", "identity:status", "", "long"), 47);
    }
}

