/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.social.addons.storage.entity.ActivityEntity;
import org.exoplatform.social.addons.storage.entity.ActivityEntity_;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity_;
import org.exoplatform.social.addons.storage.entity.StreamItemEntity;
import org.exoplatform.social.addons.storage.entity.StreamItemEntity_;
import org.exoplatform.social.addons.storage.entity.StreamType;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;

public final class AStreamQueryBuilder {
    private Identity owner;
    private long offset;
    private long limit;
    private long sinceTime = 0L;
    private boolean isNewer = false;
    private Collection<String> memberOfSpaceIds;
    private Identity myIdentity;
    private Identity viewer;
    private boolean descOrder = true;
    String[] activityTypes;

    public static AStreamQueryBuilder builder() {
        return new AStreamQueryBuilder();
    }

    public AStreamQueryBuilder owner(Identity owner) {
        this.owner = owner;
        return this;
    }

    public AStreamQueryBuilder viewer(Identity viewer) {
        this.viewer = viewer;
        return this;
    }

    public AStreamQueryBuilder myIdentity(Identity myIdentity) {
        this.myIdentity = myIdentity;
        return this;
    }

    public AStreamQueryBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public AStreamQueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public AStreamQueryBuilder activityTypes(String ... activityTypes) {
        this.activityTypes = activityTypes;
        return this;
    }

    public AStreamQueryBuilder newer(long sinceTime) {
        this.isNewer = true;
        this.sinceTime = sinceTime;
        return this;
    }

    public AStreamQueryBuilder older(long sinceTime) {
        this.isNewer = false;
        this.sinceTime = sinceTime;
        return this;
    }

    public AStreamQueryBuilder memberOfSpaceIds(Collection<String> spaceIds) {
        this.memberOfSpaceIds = spaceIds;
        return this;
    }

    public AStreamQueryBuilder ascOrder() {
        this.descOrder = false;
        return this;
    }

    public AStreamQueryBuilder descOrder() {
        this.descOrder = true;
        return this;
    }

    public TypedQuery<ActivityEntity> build() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(ActivityEntity.class);
        Root activity = criteria.from(ActivityEntity.class);
        ListJoin streamItem = activity.join(ActivityEntity_.streamItems);
        CriteriaQuery select = criteria.select((Selection)activity).distinct(true);
        select.where((Expression)this.getPredicateForStream((Root<ActivityEntity>)activity, (Join<ActivityEntity, StreamItemEntity>)streamItem, cb, criteria));
        if (this.descOrder) {
            select.orderBy(new Order[]{cb.desc((Expression)activity.get(ActivityEntity_.updatedDate))});
        } else {
            select.orderBy(new Order[]{cb.asc((Expression)activity.get(ActivityEntity_.updatedDate))});
        }
        TypedQuery typedQuery = em.createQuery(select);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<Tuple> buildId() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createTupleQuery();
        Root streamItem = criteria.from(StreamItemEntity.class);
        criteria.multiselect(new Selection[]{streamItem.get(StreamItemEntity_.activityId).alias(StreamItemEntity_.activityId.getName()), streamItem.get(StreamItemEntity_.updatedDate)}).distinct(true);
        List<Predicate> predicates = this.getPredicateForIdsStream((Root<StreamItemEntity>)streamItem, cb, criteria);
        criteria.where((Expression)cb.or(predicates.toArray(new Predicate[predicates.size()])));
        if (this.descOrder) {
            criteria.orderBy(new Order[]{cb.desc((Expression)streamItem.get(StreamItemEntity_.updatedDate))});
        } else {
            criteria.orderBy(new Order[]{cb.asc((Expression)streamItem.get(StreamItemEntity_.updatedDate))});
        }
        TypedQuery typedQuery = em.createQuery(criteria);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<Long> buildCount() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Long.class);
        Root activity = criteria.from(ActivityEntity.class);
        ListJoin streamItem = activity.join(ActivityEntity_.streamItems);
        CriteriaQuery select = criteria.select((Selection)cb.countDistinct((Expression)activity.get(ActivityEntity_.id)));
        select.where((Expression)this.getPredicateForStream((Root<ActivityEntity>)activity, (Join<ActivityEntity, StreamItemEntity>)streamItem, cb, criteria));
        return em.createQuery(select);
    }

    private Predicate getPredicateForStream(Root<ActivityEntity> activity, Join<ActivityEntity, StreamItemEntity> stream, CriteriaBuilder cb, CriteriaQuery criteria) {
        Predicate predicate = null;
        if (this.owner != null) {
            predicate = cb.equal((Expression)stream.get(StreamItemEntity_.ownerId), (Object)this.owner.getId());
            if (this.viewer != null && !this.viewer.getId().equals(this.owner.getId())) {
                predicate = cb.and((Expression)predicate, (Expression)cb.equal((Expression)activity.get(ActivityEntity_.providerId), (Object)"organization"));
            }
        }
        if (this.memberOfSpaceIds != null && this.memberOfSpaceIds.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (String id : this.memberOfSpaceIds) {
                ids.add(Long.parseLong(id));
            }
            predicate = predicate != null ? cb.or((Expression)predicate, (Expression)this.addInClause(cb, stream.get(StreamItemEntity_.ownerId), ids)) : this.addInClause(cb, stream.get(StreamItemEntity_.ownerId), ids);
        }
        if (this.myIdentity != null) {
            long identityId = Long.valueOf(this.myIdentity.getId());
            Path ownerId = stream.get(StreamItemEntity_.ownerId);
            Path streamType = stream.get(StreamItemEntity_.streamType);
            Predicate[] ps = new Predicate[2];
            Subquery sub = criteria.subquery(Long.class);
            Root conn = sub.from(ConnectionEntity.class);
            Path receiver = conn.get(ConnectionEntity_.receiver);
            Path sender = conn.get(ConnectionEntity_.sender);
            Path status = conn.get(ConnectionEntity_.status);
            sub.select((Expression)conn.get(ConnectionEntity_.id));
            sub.where(new Predicate[]{cb.equal((Expression)receiver, (Expression)ownerId), cb.equal((Expression)sender, (Object)identityId), cb.equal((Expression)status, (Object)Relationship.Type.CONFIRMED), cb.equal((Expression)streamType, (Object)StreamType.POSTER)});
            ps[0] = cb.exists(sub);
            sub = criteria.subquery(Long.class);
            conn = sub.from(ConnectionEntity.class);
            receiver = conn.get(ConnectionEntity_.receiver);
            sender = conn.get(ConnectionEntity_.sender);
            status = conn.get(ConnectionEntity_.status);
            sub.select((Expression)conn.get(ConnectionEntity_.id));
            sub.where(new Predicate[]{cb.equal((Expression)sender, (Expression)ownerId), cb.equal((Expression)receiver, (Object)identityId), cb.equal((Expression)status, (Object)Relationship.Type.CONFIRMED), cb.equal((Expression)streamType, (Object)StreamType.POSTER)});
            ps[1] = cb.exists(sub);
            predicate = predicate != null ? cb.or(new Predicate[]{predicate, ps[0], ps[1]}) : cb.or(ps);
        }
        if (this.sinceTime > 0L) {
            predicate = this.isNewer ? (predicate != null ? cb.and((Expression)predicate, (Expression)cb.greaterThan((Expression)activity.get(ActivityEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime))) : cb.greaterThan((Expression)activity.get(ActivityEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime))) : (predicate != null ? cb.and((Expression)predicate, (Expression)cb.lessThan((Expression)activity.get(ActivityEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime))) : cb.lessThan((Expression)activity.get(ActivityEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime)));
        }
        predicate = predicate != null ? cb.and((Expression)predicate, (Expression)cb.equal((Expression)activity.get(ActivityEntity_.hidden), (Object)Boolean.FALSE)) : cb.equal((Expression)activity.get(ActivityEntity_.hidden), (Object)Boolean.FALSE);
        return predicate;
    }

    private List<Predicate> getPredicateForIdsStream(Root<StreamItemEntity> stream, CriteriaBuilder cb, CriteriaQuery criteria) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate predicate = null;
        if (this.owner != null) {
            predicate = cb.equal((Expression)stream.get(StreamItemEntity_.ownerId), (Object)this.owner.getId());
            if (this.viewer != null && !this.viewer.getId().equals(this.owner.getId())) {
                predicate = cb.and((Expression)predicate, (Expression)cb.equal((Expression)stream.get(StreamItemEntity_.streamType), (Object)StreamType.POSTER));
            }
        }
        if (this.memberOfSpaceIds != null && this.memberOfSpaceIds.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (String id : this.memberOfSpaceIds) {
                ids.add(Long.parseLong(id));
            }
            predicates.add(this.addInClause(cb, stream.get(StreamItemEntity_.ownerId), ids));
        }
        if (this.myIdentity != null) {
            long identityId = Long.valueOf(this.myIdentity.getId());
            Path ownerId = stream.get(StreamItemEntity_.ownerId);
            Path streamType = stream.get(StreamItemEntity_.streamType);
            Subquery sub = criteria.subquery(Long.class);
            Root conn = sub.from(ConnectionEntity.class);
            Path receiver = conn.get(ConnectionEntity_.receiver);
            Path sender = conn.get(ConnectionEntity_.sender);
            Path status = conn.get(ConnectionEntity_.status);
            sub.select((Expression)conn.get(ConnectionEntity_.id));
            sub.where(new Predicate[]{cb.equal((Expression)receiver, (Expression)ownerId), cb.equal((Expression)sender, (Object)identityId), cb.equal((Expression)status, (Object)Relationship.Type.CONFIRMED), cb.equal((Expression)streamType, (Object)StreamType.POSTER)});
            predicates.add(cb.exists(sub));
            sub = criteria.subquery(Long.class);
            conn = sub.from(ConnectionEntity.class);
            receiver = conn.get(ConnectionEntity_.receiver);
            sender = conn.get(ConnectionEntity_.sender);
            status = conn.get(ConnectionEntity_.status);
            sub.select((Expression)conn.get(ConnectionEntity_.id));
            sub.where(new Predicate[]{cb.equal((Expression)sender, (Expression)ownerId), cb.equal((Expression)receiver, (Object)identityId), cb.equal((Expression)status, (Object)Relationship.Type.CONFIRMED), cb.equal((Expression)streamType, (Object)StreamType.POSTER)});
            predicates.add(cb.exists(sub));
        }
        if (this.sinceTime > 0L) {
            predicate = this.isNewer ? (predicate != null ? cb.and((Expression)predicate, (Expression)cb.greaterThan((Expression)stream.get(StreamItemEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime))) : cb.greaterThan((Expression)stream.get(StreamItemEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime))) : (predicate != null ? cb.and((Expression)predicate, (Expression)cb.lessThan((Expression)stream.get(StreamItemEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime))) : cb.lessThan((Expression)stream.get(StreamItemEntity_.updatedDate), (Comparable)Long.valueOf(this.sinceTime)));
        }
        if (predicate != null) {
            predicates.add(predicate);
        }
        return predicates;
    }

    private <T> Predicate addInClause(CriteriaBuilder cb, Path<T> pathColumn, Collection<T> values) {
        CriteriaBuilder.In in = cb.in(pathColumn);
        for (T value : values) {
            in.value(value);
        }
        return in;
    }

    public TypedQuery<ActivityEntity> buildGetActivitiesByPoster() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(ActivityEntity.class);
        Root activity = criteria.from(ActivityEntity.class);
        Predicate predicate = cb.equal((Expression)activity.get(ActivityEntity_.posterId), (Object)this.owner.getId());
        if (this.activityTypes != null && this.activityTypes.length > 0) {
            ArrayList<String> types = new ArrayList<String>(Arrays.asList(this.activityTypes));
            predicate = cb.and((Expression)predicate, (Expression)this.addInClause(cb, activity.get(ActivityEntity_.type), types));
        }
        CriteriaQuery select = criteria.select((Selection)activity).distinct(true);
        select.where((Expression)predicate);
        select.orderBy(new Order[]{cb.desc((Expression)activity.get(ActivityEntity_.updatedDate))});
        TypedQuery typedQuery = em.createQuery(select);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<Long> buildActivitiesByPosterCount() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Long.class);
        Root activity = criteria.from(ActivityEntity.class);
        Predicate predicate = cb.equal((Expression)activity.get(ActivityEntity_.posterId), (Object)this.owner.getId());
        if (this.activityTypes != null && this.activityTypes.length > 0) {
            ArrayList<String> types = new ArrayList<String>(Arrays.asList(this.activityTypes));
            predicate = cb.and((Expression)predicate, (Expression)this.addInClause(cb, activity.get(ActivityEntity_.type), types));
        }
        CriteriaQuery select = criteria.select((Selection)cb.countDistinct((Expression)activity));
        select.where((Expression)predicate);
        return em.createQuery(select);
    }
}

