/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.updater.listener;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.addons.storage.entity.MentionEntity;
import org.exoplatform.social.core.identity.model.Identity;

public class IdentityReferenceUpdaterListener
extends Listener<Identity, String> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Identity, String> event) throws Exception {
        EntityManagerService emService = (EntityManagerService)CommonsUtils.getService(EntityManagerService.class);
        EntityManager em = emService.getEntityManager();
        if (em == null) {
            return;
        }
        boolean startTx = false;
        try {
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
                startTx = true;
            }
            Identity identity = (Identity)event.getSource();
            String newId = (String)event.getData();
            String oldId = identity.getId();
            Query query = em.createNamedQuery("SocActivity.migratePosterId");
            query.setParameter("newId", (Object)newId);
            query.setParameter("oldId", (Object)oldId);
            query.executeUpdate();
            query = em.createNamedQuery("SocActivity.migrateOwnerId");
            query.setParameter("newId", (Object)newId);
            query.setParameter("oldId", (Object)oldId);
            query.executeUpdate();
            query = em.createNamedQuery("SocMention.migrateMentionId");
            query.setParameter("newId", (Object)newId);
            query.setParameter("oldId", (Object)oldId);
            query.executeUpdate();
            query = em.createNamedQuery("SocMention.selectMentionByOldId", MentionEntity.class);
            query.setParameter("oldId", (Object)(oldId + "@%"));
            List list = query.getResultList();
            if (list != null && list.size() > 0) {
                for (MentionEntity m : list) {
                    String mentionId = m.getMentionId();
                    mentionId = mentionId.replace(oldId, newId);
                    m.setMentionId(mentionId);
                    em.merge((Object)m);
                }
            }
            query = em.createNativeQuery("UPDATE SOC_ACTIVITY_LIKERS SET LIKER_ID = ? WHERE LIKER_ID = ?");
            query.setParameter(1, (Object)newId);
            query.setParameter(2, (Object)oldId);
            query.executeUpdate();
        }
        finally {
            if (startTx) {
                em.getTransaction().commit();
            }
        }
    }
}

