/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.updater.utils;

public class MigrationCounter {
    private int batch = 0;
    private long batchWatch = 0L;
    private int total = 0;
    private long totalWatch = 0L;
    private int threshold = 0;

    public static MigrationCounterBuilder builder() {
        return new MigrationCounterBuilder();
    }

    public int getAndIncrementTotal() {
        ++this.total;
        return this.total;
    }

    public int getAndIncrementBatch() {
        ++this.batch;
        return this.batch;
    }

    public void newBatchAndWatch() {
        this.batch = 0;
        this.batchWatch = System.currentTimeMillis();
    }

    public long endBatchWatch() {
        return System.currentTimeMillis() - this.batchWatch;
    }

    public int getBatch() {
        return this.batch;
    }

    public void newTotal() {
        this.total = 0;
    }

    public void newTotalAndWatch() {
        this.total = 0;
        this.totalWatch = System.currentTimeMillis();
    }

    public long endTotalWatch() {
        return System.currentTimeMillis() - this.totalWatch;
    }

    public int getTotal() {
        return this.total;
    }

    public void newBatch() {
        this.batch = 0;
    }

    public boolean isPersistPoint() {
        return this.total % this.threshold == 0;
    }

    public void resetBatch() {
        this.batch = 0;
    }

    public void reset() {
        this.batch = 0;
        this.total = 0;
        this.batchWatch = 0L;
        this.totalWatch = 0L;
    }

    public static class MigrationCounterBuilder {
        private int batch = 0;
        private int threshold = 0;

        public MigrationCounterBuilder startAtBatch(int fromBatch) {
            this.batch += fromBatch;
            return this;
        }

        public MigrationCounterBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public MigrationCounter build() {
            MigrationCounter counter = new MigrationCounter();
            counter.batch = this.batch;
            counter.threshold = this.threshold;
            return counter;
        }
    }
}

