/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.spacesadministration;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.addons.spacesadministration.SpacesAdministrationStorage;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

public class SpacesAdministrationService {
    private Log log = ExoLogger.getLogger(SpacesAdministrationService.class);
    public static final String SPACES_CREATE_MEMBERSHIPS_PROPERTY = "exo.spaces.create.memberships";
    private InitParams initParams;
    private SpacesAdministrationStorage spacesAdministrationStorage;

    public SpacesAdministrationService(InitParams initParams, SpacesAdministrationStorage spacesAdministrationStorage) {
        this.initParams = initParams;
        this.spacesAdministrationStorage = spacesAdministrationStorage;
    }

    public boolean canCreateSpace() {
        boolean canCreateSpace;
        block4: {
            canCreateSpace = false;
            try {
                List<MembershipEntry> memberships = this.getSpaceCreationMemberships();
                if (memberships == null || memberships.isEmpty()) {
                    canCreateSpace = true;
                    break block4;
                }
                Identity userIdentity = ConversationState.getCurrent().getIdentity();
                for (MembershipEntry membership : memberships) {
                    if (!userIdentity.isMemberOf(membership)) continue;
                    canCreateSpace = true;
                    break;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Error while checking if the user can create spaces - Cause : " + e.getMessage()), (Throwable)e);
                canCreateSpace = false;
            }
        }
        return canCreateSpace;
    }

    public void createSettingsEntityWithDefaultValues() throws Exception {
        if (this.spacesAdministrationStorage.settingsEntityExists()) {
            throw new Exception("Settings Entity already exists - Cannot create it");
        }
        this.spacesAdministrationStorage.createSettingsEntity();
        ValueParam createMembershipInitParam = this.initParams.getValueParam(SPACES_CREATE_MEMBERSHIPS_PROPERTY);
        if (createMembershipInitParam != null) {
            List<MembershipEntry> membershipEntries = this.convertMembershipsToMemebershipEntries(createMembershipInitParam.getValue());
            for (MembershipEntry membershipEntry : membershipEntries) {
                this.spacesAdministrationStorage.addSpaceCreationMembership(membershipEntry);
            }
        }
    }

    public void addSpaceCreationMembership(MembershipEntry membership) throws Exception {
        if (membership == null) {
            throw new IllegalArgumentException("Cannot add null membership");
        }
        if (!this.spacesAdministrationStorage.settingsEntityExists()) {
            this.createSettingsEntityWithDefaultValues();
        }
        this.spacesAdministrationStorage.addSpaceCreationMembership(membership);
    }

    public void deleteSpaceCreationMembership(MembershipEntry membership) throws Exception {
        if (membership == null) {
            throw new IllegalArgumentException("Cannot delete null membership");
        }
        if (!this.spacesAdministrationStorage.settingsEntityExists()) {
            this.createSettingsEntityWithDefaultValues();
        }
        this.spacesAdministrationStorage.deleteSpaceCreationMembership(membership);
    }

    public List<MembershipEntry> getSpaceCreationMemberships() throws Exception {
        List<Object> memberships = new ArrayList();
        if (this.spacesAdministrationStorage.settingsEntityExists()) {
            memberships = this.spacesAdministrationStorage.getSpaceCreationMemberships();
        } else {
            ValueParam createMembershipInitParam = this.initParams.getValueParam(SPACES_CREATE_MEMBERSHIPS_PROPERTY);
            if (createMembershipInitParam != null) {
                memberships = this.convertMembershipsToMemebershipEntries(createMembershipInitParam.getValue());
            } else {
                this.log.warn((Object)"exo.spaces.create.memberships is not defined - nobody can create spaces");
            }
        }
        return memberships;
    }

    public void deleteSettingsEntity() throws Exception {
        this.spacesAdministrationStorage.deleteSettingsEntity();
    }

    protected List<MembershipEntry> convertMembershipsToMemebershipEntries(String memberships) {
        String[] membershipsSplitted;
        ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
        for (String membership : membershipsSplitted = memberships.split(",")) {
            String[] membershipSplitted = membership.split(":");
            if (membershipSplitted.length == 2) {
                membershipEntries.add(new MembershipEntry(membershipSplitted[1], membershipSplitted[0]));
                continue;
            }
            this.log.warn((Object)("Wrong format for spaces administration membership : " + membership));
        }
        return membershipEntries;
    }
}

