/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.spacesadministration.portlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.template.Template;
import org.exoplatform.addons.spacesadministration.SpacesAdministrationService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.MembershipEntry;

public class SpacesAdministrationController {
    private static Log log = ExoLogger.getLogger(SpacesAdministrationController.class);
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    @Inject
    ResourceBundle resourceBundle;
    private SpacesAdministrationService spacesAdministrationService = (SpacesAdministrationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpacesAdministrationService.class);
    private OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);

    @View
    public Response.Render index() {
        HashMap parameters = new HashMap();
        try {
            ArrayList membershipTypes = new ArrayList(this.organizationService.getMembershipTypeHandler().findMembershipTypes());
            Collections.sort(membershipTypes, new /* Unavailable Anonymous Inner Class!! */);
            parameters.put("membershipTypes", membershipTypes);
            ArrayList groups = new ArrayList(this.organizationService.getGroupHandler().getAllGroups());
            Collections.sort(groups, new /* Unavailable Anonymous Inner Class!! */);
            parameters.put("groups", groups);
        }
        catch (Exception e) {
            log.error((Object)("Error while getting all the membership types and groups - Cause : " + e.getMessage()), (Throwable)e);
        }
        return this.indexTmpl.ok(parameters);
    }

    @Ajax
    @Resource
    public Response getI18n() {
        StringBuilder jsonResourceBundle = new StringBuilder("[");
        Enumeration<String> resourceBundleKeys = this.resourceBundle.getKeys();
        while (resourceBundleKeys.hasMoreElements()) {
            String key = resourceBundleKeys.nextElement();
            if (!key.startsWith("spacesadministration.")) continue;
            jsonResourceBundle.append("{\"key\":\"").append(key).append("\",\"value\":\"").append(this.resourceBundle.getString(key)).append("\"},");
        }
        if (jsonResourceBundle.length() > 1) {
            jsonResourceBundle.deleteCharAt(jsonResourceBundle.length() - 1);
        }
        jsonResourceBundle.append("]");
        return Response.ok((CharSequence)jsonResourceBundle.toString());
    }

    @Ajax
    @Resource
    public Response getMemberships() {
        List createMemberships = null;
        try {
            createMemberships = this.spacesAdministrationService.getSpaceCreationMemberships();
        }
        catch (Exception e) {
            log.error((Object)("Error while getting the memberships for spaces administration - Cause : " + e.getMessage()), (Throwable)e);
            return Response.error((String)"Error while getting the memberships");
        }
        StringBuilder jsonMemberships = new StringBuilder("[");
        if (createMemberships != null && !createMemberships.isEmpty()) {
            for (MembershipEntry membershipEntry : createMemberships) {
                jsonMemberships.append("\"").append(membershipEntry.getMembershipType()).append(":").append(membershipEntry.getGroup()).append("\",");
            }
            jsonMemberships.deleteCharAt(jsonMemberships.length() - 1);
        }
        jsonMemberships.append("]");
        return Response.ok((CharSequence)jsonMemberships.toString());
    }

    @Ajax
    @Resource
    public Response resetToDefaults() {
        try {
            this.spacesAdministrationService.deleteSettingsEntity();
        }
        catch (Exception e) {
            log.error((Object)("Error while reseting the memberships to default values for spaces administration - Cause : " + e.getMessage()), (Throwable)e);
            return Response.error((String)"Error while reseting memberships to default values");
        }
        return this.getMemberships();
    }

    @Ajax
    @Resource
    public Response add(String membership) {
        if (membership != null) {
            String[] membershipArray = membership.split(":");
            MembershipEntry membershipEntry = new MembershipEntry(membershipArray[1], membershipArray[0]);
            try {
                this.spacesAdministrationService.addSpaceCreationMembership(membershipEntry);
            }
            catch (Exception e) {
                log.error((Object)("Error while adding the membership " + membership + " for spaces administration - Cause : " + e.getMessage()), (Throwable)e);
                return Response.error((String)("Error while adding the membership " + membership + " for spaces administration"));
            }
        }
        return Response.ok((CharSequence)"");
    }

    @Ajax
    @Resource
    public Response delete(String membership) {
        if (membership != null) {
            String[] membershipArray = membership.split(":");
            MembershipEntry membershipEntry = new MembershipEntry(membershipArray[1], membershipArray[0]);
            try {
                this.spacesAdministrationService.deleteSpaceCreationMembership(membershipEntry);
            }
            catch (Exception e) {
                log.error((Object)("Error while deleting the membership " + membership + " for spaces administration - Cause : " + e.getMessage()), (Throwable)e);
                return Response.error((String)("Error while deleting the membership " + membership + " for spaces administration"));
            }
        }
        return Response.ok((CharSequence)"");
    }
}

