/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.PicketLinkConfigParser;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.parsers.SAMLConfigParser;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public abstract class AbstractSAMLConfigurationProvider
implements SAMLConfigurationProvider {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String VALIDATING_ALIAS = "ValidatingAlias";
    protected IDPType configParsedIDPType = null;
    protected SPType configParsedSPType = null;
    protected PicketLinkType configParsedPicketLinkType = null;

    @Deprecated
    public void setConfigFile(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        SAMLConfigParser parser = new SAMLConfigParser();
        Object parsedObject = parser.parse(is);
        if (parsedObject instanceof IDPType) {
            this.configParsedIDPType = (IDPType)parsedObject;
        } else {
            this.configParsedSPType = (SPType)parsedObject;
        }
    }

    public void setConsolidatedConfigFile(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        PicketLinkConfigParser parser = new PicketLinkConfigParser();
        PicketLinkType parsedObject = (PicketLinkType)parser.parse(is);
        if (parsedObject.getIdpOrSP() instanceof IDPType) {
            this.configParsedIDPType = (IDPType)parsedObject.getIdpOrSP();
        } else {
            this.configParsedSPType = (SPType)parsedObject.getIdpOrSP();
        }
        this.configParsedPicketLinkType = parsedObject;
    }

    @Override
    public abstract IDPType getIDPConfiguration() throws ProcessingException;

    @Override
    public abstract SPType getSPConfiguration() throws ProcessingException;

    @Override
    public PicketLinkType getPicketLinkConfiguration() throws ProcessingException {
        return this.configParsedPicketLinkType;
    }
}

