/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLStatusResponseTypeParser;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;

public class SAMLSloResponseParser
extends SAMLStatusResponseTypeParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.LOGOUT_RESPONSE.get());
        StatusResponseType response = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                response.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)JBossSAMLConstants.SIGNATURE.get());
                continue;
            }
            if (!JBossSAMLConstants.STATUS.get().equals(elementName)) continue;
            response.setStatus(this.parseStatus(xmlEventReader));
        }
        return response;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && JBossSAMLConstants.LOGOUT_RESPONSE.equals((Object)qname.getLocalPart());
    }
}

