/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1.writers;

import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.identity.federation.core.saml.v1.writers.BaseSAML11Writer;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11AssertionWriter;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ActionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeDesignatorType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11EvidenceType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AttributeQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AuthenticationQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AuthorizationDecisionQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11QueryAbstractType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11RequestType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11SubjectQueryAbstractType;

public class SAML11RequestWriter
extends BaseSAML11Writer {
    protected String namespace = "urn:oasis:names:tc:SAML:1.0:protocol";
    protected SAML11AssertionWriter assertionWriter;

    public SAML11RequestWriter(XMLStreamWriter writer) {
        super(writer);
        this.assertionWriter = new SAML11AssertionWriter(writer);
    }

    public void write(SAML11RequestType request) throws ProcessingException {
        SAML11SubjectQueryAbstractType attQuery;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"Request", (String)this.namespace);
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)this.namespace);
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)this.namespace);
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"RequestID", (String)request.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"MajorVersion", (String)(request.getMajorVersion() + ""));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"MinorVersion", (String)(request.getMinorVersion() + ""));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)request.getIssueInstant().toString());
        List<String> assertionIDRefs = request.getAssertionIDRef();
        for (String string : assertionIDRefs) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"AssertionIDReference", (String)"urn:oasis:names:tc:SAML:1.0:assertion");
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)string);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        List<String> assertionArtifacts = request.getAssertionArtifact();
        for (String assertionArtifact : assertionArtifacts) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"AssertionArtifact", (String)this.namespace);
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)assertionArtifact);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        SAML11QueryAbstractType sAML11QueryAbstractType = request.getQuery();
        if (sAML11QueryAbstractType instanceof SAML11AuthenticationQueryType) {
            SAML11AuthenticationQueryType authQuery = (SAML11AuthenticationQueryType)sAML11QueryAbstractType;
            this.write(authQuery);
        } else if (sAML11QueryAbstractType instanceof SAML11AttributeQueryType) {
            attQuery = (SAML11AttributeQueryType)sAML11QueryAbstractType;
            this.write((SAML11AttributeQueryType)attQuery);
        } else if (sAML11QueryAbstractType instanceof SAML11AuthenticationQueryType) {
            attQuery = (SAML11AuthenticationQueryType)sAML11QueryAbstractType;
            this.write((SAML11AuthenticationQueryType)attQuery);
        } else if (sAML11QueryAbstractType instanceof SAML11AuthorizationDecisionQueryType) {
            attQuery = (SAML11AuthorizationDecisionQueryType)sAML11QueryAbstractType;
            this.write((SAML11AuthorizationDecisionQueryType)attQuery);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AuthenticationQueryType auth) throws ProcessingException {
        SAML11SubjectType subject;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"AuthenticationQuery", (String)this.namespace);
        URI authMethod = auth.getAuthenticationMethod();
        if (authMethod != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AuthenticationMethod", (String)authMethod.toString());
        }
        if ((subject = auth.getSubject()) != null) {
            this.assertionWriter.write(subject);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AttributeQueryType attr) throws ProcessingException {
        SAML11SubjectType subject;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"AttributeQuery", (String)this.namespace);
        URI resource = attr.getResource();
        if (resource != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Resource", (String)resource.toString());
        }
        if ((subject = attr.getSubject()) != null) {
            this.assertionWriter.write(subject);
        }
        List<SAML11AttributeDesignatorType> attributes = attr.get();
        for (SAML11AttributeDesignatorType attribute : attributes) {
            if (attribute instanceof SAML11AttributeType) {
                SAML11AttributeType sat = (SAML11AttributeType)attribute;
                this.assertionWriter.write(sat);
                continue;
            }
            throw logger.writerUnknownTypeError(attribute.getClass().getName());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AuthorizationDecisionQueryType attr) throws ProcessingException {
        SAML11SubjectType subject;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"AuthorizationDecisionQuery", (String)this.namespace);
        URI resource = attr.getResource();
        if (resource != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Resource", (String)resource.toString());
        }
        if ((subject = attr.getSubject()) != null) {
            this.assertionWriter.write(subject);
        }
        List<SAML11ActionType> actions = attr.get();
        for (SAML11ActionType action : actions) {
            this.assertionWriter.write(action);
        }
        SAML11EvidenceType evidence = attr.getEvidence();
        if (evidence != null) {
            this.assertionWriter.write(evidence);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }
}

