/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat;

import java.io.IOException;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;

public abstract class AbstractGenericHeaderAuthenticator
extends FormAuthenticator {
    protected static final PicketLinkLogger log = PicketLinkLoggerFactory.getLogger();
    private String httpHeaderForSSOAuth = null;
    private String sessionCookieForSSOAuth = null;

    public String getHttpHeaderForSSOAuth() {
        return this.httpHeaderForSSOAuth;
    }

    public void setHttpHeaderForSSOAuth(String httpHeaderForSSOAuth) {
        this.httpHeaderForSSOAuth = httpHeaderForSSOAuth;
    }

    public String getSessionCookieForSSOAuth() {
        return this.sessionCookieForSSOAuth;
    }

    public void setSessionCookieForSSOAuth(String sessionCookieForSSOAuth) {
        this.sessionCookieForSSOAuth = sessionCookieForSSOAuth;
    }

    public boolean performAuthentication(Request request, Response response, LoginConfig config) throws IOException {
        Principal principal;
        boolean trace = log.isTraceEnabled();
        if (log.isTraceEnabled()) {
            log.trace("Authenticating user");
        }
        if ((principal = request.getUserPrincipal()) != null) {
            if (trace) {
                log.trace("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        Realm realm = this.context.getRealm();
        Session session = request.getSessionInternal(true);
        String username = this.getUserId(request);
        String password = this.getSessionCookie(request);
        if (username == null || password == null) {
            if (log.isTraceEnabled()) {
                log.trace("Username is null or password(sessionkey) is null:fallback to form auth");
            }
            return super.authenticate(request, response, config);
        }
        principal = realm.authenticate(username, password);
        if (principal == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
        request.setUserPrincipal(principal);
        this.register(request, response, principal, "FORM", username, password);
        return true;
    }

    protected String getUserId(Request request) {
        String ssoid = null;
        String ids = this.httpHeaderForSSOAuth;
        if (ids == null || ids.length() == 0) {
            throw new IllegalStateException("Http headers configuration in tomcat service missing");
        }
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens() && (ssoid = request.getHeader(st.nextToken())) == null) {
        }
        if (log.isTraceEnabled()) {
            log.trace("SSOID-" + ssoid);
        }
        return ssoid;
    }

    protected String getSessionCookie(Request request) {
        Cookie[] cookies = request.getCookies();
        log.trace("Cookies:" + cookies);
        int numCookies = cookies != null ? cookies.length : 0;
        String ids = this.sessionCookieForSSOAuth;
        if (ids == null || ids.length() == 0) {
            throw new IllegalStateException("Session cookies configuration in tomcat service missing");
        }
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens()) {
            String cookieToken = st.nextToken();
            String val = this.getCookieValue(cookies, numCookies, cookieToken);
            if (val == null) continue;
            return val;
        }
        if (log.isTraceEnabled()) {
            log.trace("Session Cookie not found");
        }
        return null;
    }

    protected String getCookieValue(Cookie[] cookies, int numCookies, String token) {
        for (int i = 0; i < numCookies; ++i) {
            Cookie cookie = cookies[i];
            log.trace("Matching cookieToken:" + token + " with cookie name=" + cookie.getName());
            if (!token.equals(cookie.getName())) continue;
            if (log.isTraceEnabled()) {
                log.trace("Cookie-" + token + " value=" + cookie.getValue());
            }
            return cookie.getValue();
        }
        return null;
    }
}

