/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import org.picketlink.common.util.DocumentUtil;
import org.w3c.dom.Document;

public class SOAPUtil {
    public static SOAPMessage create() throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        return soapMessage;
    }

    public static SOAPMessage createSOAP12() throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        SOAPMessage soapMessage = messageFactory.createMessage();
        return soapMessage;
    }

    public static SOAPMessage getSOAPMessage(InputStream is) throws IOException, SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        return messageFactory.createMessage(null, is);
    }

    public static SOAPMessage getSOAP12Message(InputStream is) throws IOException, SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        return messageFactory.createMessage(null, is);
    }

    public static SOAPMessage createFault(String message) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage msg = messageFactory.createMessage();
        SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPFault fault = body.addFault();
        fault.setFaultCode("Server");
        fault.setFaultActor("urn:picketlink");
        fault.setFaultString(message);
        return msg;
    }

    public static SOAPMessage createFault12(String message) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        SOAPMessage msg = messageFactory.createMessage();
        SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPFault fault = body.addFault();
        fault.setFaultCode("Server");
        fault.setFaultActor("urn:picketlink");
        fault.setFaultString(message);
        return msg;
    }

    public static Document getSOAPData(SOAPMessage soapMessage) throws SOAPException {
        return soapMessage.getSOAPBody().extractContentAsDocument();
    }

    public static boolean isSOAP12(SOAPMessage soapMessage) throws SOAPException {
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        return "http://www.w3.org/2003/05/soap-envelope".equals(soapEnvelope.getNamespaceURI());
    }

    public static void addData(Source data, SOAPMessage soapMessage) throws SOAPException {
        try {
            soapMessage.getSOAPBody().addDocument(DocumentUtil.getDocumentFromSource((Source)data));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String soapMessageAsString(SOAPMessage soapMessage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            soapMessage.writeTo((OutputStream)baos);
        }
        catch (Exception almostIgnored) {
            return "PL00104: Error while dumping SOAP message:" + almostIgnored;
        }
        return baos.toString();
    }
}

