/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins.saml;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.wstrust.StandardSecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestContext;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AudienceRestrictionCondition;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionsType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.w3c.dom.Element;

public class SAML11TokenProvider
extends AbstractSecurityTokenProvider {
    private boolean useAbsoluteKeyIdentifier;

    @Override
    public void cancelToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        Element token = wstContext.getRequestSecurityToken().getCancelTargetElement();
        if (token == null) {
            throw logger.wsTrustNullCancelTargetError();
        }
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isSAMLAssertion(assertionElement)) {
            throw logger.assertionInvalidError();
        }
        String assertionId = assertionElement.getAttribute("AssertionID");
        this.revocationRegistry.revokeToken("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", assertionId);
        String absoluteKI = (String)this.properties.get("USE_ABSOLUTE_KEYIDENTIFIER");
        if (absoluteKI != null && "true".equalsIgnoreCase(absoluteKI)) {
            this.useAbsoluteKeyIdentifier = true;
        }
    }

    @Override
    public void issueToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        String assertionID = IDGenerator.create("ID_");
        Lifetime lifetime = this.adjustLifetimeForClockSkew(wstContext.getRequestSecurityToken().getLifetime());
        SAML11AudienceRestrictionCondition restriction = null;
        AppliesTo appliesTo = wstContext.getRequestSecurityToken().getAppliesTo();
        if (appliesTo != null) {
            restriction = new SAML11AudienceRestrictionCondition();
            restriction.add(URI.create(WSTrustUtil.parseAppliesTo(appliesTo)));
        }
        SAML11ConditionsType conditions = new SAML11ConditionsType();
        conditions.setNotBefore(lifetime.getCreated());
        conditions.setNotOnOrAfter(lifetime.getExpires());
        conditions.add(restriction);
        Principal principal = wstContext.getCallerPrincipal();
        String confirmationMethod = null;
        KeyInfoType keyInfoType = null;
        if (wstContext.getOnBehalfOfPrincipal() != null) {
            principal = wstContext.getOnBehalfOfPrincipal();
            confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        } else if (wstContext.getProofTokenInfo() != null) {
            confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
            keyInfoType = wstContext.getProofTokenInfo();
        } else {
            confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
        }
        SAML11SubjectConfirmationType subjectConfirmation = new SAML11SubjectConfirmationType();
        subjectConfirmation.addConfirmationMethod(URI.create(confirmationMethod));
        if (keyInfoType != null) {
            throw logger.notImplementedYet("KeyInfoType");
        }
        String subjectName = principal == null ? "ANONYMOUS" : principal.getName();
        SAML11NameIdentifierType nameId = new SAML11NameIdentifierType(subjectName);
        nameId.setFormat(URI.create("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
        SAML11SubjectType subject = new SAML11SubjectType();
        subject.setChoice(new SAML11SubjectType.SAML11SubjectTypeChoice(nameId));
        subject.setSubjectConfirmation(subjectConfirmation);
        SAML11AuthenticationStatementType authStatement = new SAML11AuthenticationStatementType(URI.create("urn:picketlink:auth"), lifetime.getCreated());
        authStatement.setSubject(subject);
        SAML11AssertionType assertion = new SAML11AssertionType(assertionID, lifetime.getCreated());
        assertion.add(authStatement);
        assertion.setConditions(conditions);
        assertion.setIssuer(wstContext.getTokenIssuer());
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(assertion);
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError((Throwable)e);
        }
        StandardSecurityToken token = new StandardSecurityToken(wstContext.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        wstContext.setSecurityToken(token);
        String keyIdentifierValue = assertionID;
        if (!this.useAbsoluteKeyIdentifier) {
            keyIdentifierValue = "#" + keyIdentifierValue;
        }
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", keyIdentifierValue);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", "wsse11"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        wstContext.setAttachedReference(attachedReference);
    }

    @Override
    public void renewToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        Element token = wstContext.getRequestSecurityToken().getRenewTargetElement();
        if (token == null) {
            throw logger.wsTrustNullRenewTargetError();
        }
        Element oldAssertionElement = (Element)token.getFirstChild();
        if (!this.isSAMLAssertion(oldAssertionElement)) {
            throw logger.assertionInvalidError();
        }
        SAML11AssertionType oldAssertion = null;
        try {
            oldAssertion = SAMLUtil.saml11FromElement(oldAssertionElement);
        }
        catch (Exception je) {
            throw logger.samlAssertionUnmarshallError((Throwable)je);
        }
        if (this.revocationRegistry.isRevoked("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", oldAssertion.getID())) {
            throw logger.samlAssertionRevokedCouldNotRenew(oldAssertion.getID());
        }
        SAML11ConditionsType conditions = oldAssertion.getConditions();
        Lifetime lifetime = this.adjustLifetimeForClockSkew(wstContext.getRequestSecurityToken().getLifetime());
        conditions.setNotBefore(lifetime.getCreated());
        conditions.setNotOnOrAfter(lifetime.getExpires());
        String assertionID = IDGenerator.create("ID_");
        ArrayList<SAML11StatementAbstractType> statements = new ArrayList<SAML11StatementAbstractType>();
        statements.addAll(oldAssertion.getStatements());
        SAML11AssertionType newAssertion = new SAML11AssertionType(assertionID, conditions.getNotBefore());
        newAssertion.addAllStatements(statements);
        newAssertion.setConditions(conditions);
        newAssertion.setIssuer(wstContext.getTokenIssuer());
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(newAssertion);
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError((Throwable)e);
        }
        StandardSecurityToken securityToken = new StandardSecurityToken(wstContext.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        wstContext.setSecurityToken(securityToken);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        wstContext.setAttachedReference(attachedReference);
    }

    @Override
    public void validateToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        logger.trace("SAML token validation started");
        Element token = wstContext.getRequestSecurityToken().getValidateTargetElement();
        if (token == null) {
            throw logger.wsTrustNullValidationTargetError();
        }
        String code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
        String reason = "SAMLV1.1 Assertion successfuly validated";
        SAML11AssertionType assertion = null;
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isSAMLAssertion(assertionElement)) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: supplied token is not a SAMLV1.1 Assertion";
        } else {
            try {
                assertion = SAMLUtil.saml11FromElement(assertionElement);
            }
            catch (Exception e) {
                throw logger.samlAssertionUnmarshallError((Throwable)e);
            }
        }
        if (this.revocationRegistry.isRevoked("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", assertion.getID())) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: assertion with id " + assertion.getID() + " has been canceled";
        }
        try {
            if (AssertionUtil.hasExpired(assertion, this.getClockSkewInMillis())) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: assertion expired or used before its lifetime period";
            }
        }
        catch (Exception ce) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: unable to verify assertion lifetime: " + ce.getMessage();
        }
        StatusType status = new StatusType();
        status.setCode(code);
        status.setReason(reason);
        wstContext.setStatus(status);
    }

    @Override
    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.WS_TRUST.toString();
    }

    @Override
    public QName getSupportedQName() {
        return new QName(this.tokenType(), JBossSAMLConstants.ASSERTION.get());
    }

    @Override
    public boolean supports(String namespace) {
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace);
    }

    @Override
    public String tokenType() {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    }

    private boolean isSAMLAssertion(Element element) {
        return element == null ? false : "Assertion".equals(element.getLocalName()) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(element.getNamespaceURI());
    }
}

