/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.RunAs;
import org.jboss.security.SubjectInfo;
import org.jboss.security.identity.extensions.CredentialIdentity;

public class SecurityIdentity {
    SubjectInfo theSubjectInfo = null;
    RunAs runAs = null;
    RunAs callerRunAs = null;

    public SecurityIdentity(SubjectInfo subject, RunAs outgoingRunAs, RunAs incomingRunAs) {
        this.theSubjectInfo = subject;
        this.runAs = outgoingRunAs;
        this.callerRunAs = incomingRunAs;
    }

    public Principal getPrincipal() {
        CredentialIdentity identity;
        if (this.theSubjectInfo != null && (identity = this.theSubjectInfo.getIdentity(CredentialIdentity.class)) != null) {
            return identity.asPrincipal();
        }
        return null;
    }

    public Object getCredential() {
        CredentialIdentity identity;
        if (this.theSubjectInfo != null && (identity = this.theSubjectInfo.getIdentity(CredentialIdentity.class)) != null) {
            return identity.getCredential();
        }
        return null;
    }

    public Subject getSubject() {
        return this.theSubjectInfo != null ? this.theSubjectInfo.getAuthenticatedSubject() : null;
    }

    public RunAs getOutgoingRunAs() {
        return this.runAs;
    }

    public RunAs getIncomingRunAs() {
        return this.callerRunAs;
    }
}

