/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.federation;

import org.picketlink.config.federation.IdentityURLProviderType;
import org.picketlink.config.federation.ProviderType;

public class SPType
extends ProviderType {
    protected String serviceURL;
    protected String idpMetadataFile;
    protected String bindingType = "POST";
    protected String relayState;
    protected String errorPage = "/error.jsp";
    protected boolean idpUsesPostBinding = true;
    private String logOutPage = "/logout.jsp";
    private String logoutUrl;
    private String logoutResponseLocation;
    private IdentityURLProviderType identityURLProvider;

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String value) {
        this.serviceURL = value;
    }

    public String getIdpMetadataFile() {
        return this.idpMetadataFile;
    }

    public void setIdpMetadataFile(String idpMetadataFile) {
        this.idpMetadataFile = idpMetadataFile;
    }

    public String getBindingType() {
        return this.bindingType;
    }

    public void setBindingType(String bindingType) {
        if (!bindingType.equals("POST") && !bindingType.equals("REDIRECT")) {
            throw new IllegalArgumentException();
        }
        this.bindingType = bindingType;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public boolean isIdpUsesPostBinding() {
        return this.idpUsesPostBinding;
    }

    public void setIdpUsesPostBinding(boolean idpPostBinding) {
        this.idpUsesPostBinding = idpPostBinding;
    }

    public String getLogOutPage() {
        return this.logOutPage;
    }

    public void setLogOutPage(String logOutPage) {
        this.logOutPage = logOutPage;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getLogoutResponseLocation() {
        return this.logoutResponseLocation;
    }

    public void setLogoutResponseLocation(String logoutResponseLocation) {
        this.logoutResponseLocation = logoutResponseLocation;
    }

    @Override
    public void importFrom(ProviderType other) {
        super.importFrom(other);
        if (SPType.class.isInstance(other)) {
            SPType otherType = (SPType)other;
            this.setIdpMetadataFile(otherType.getIdpMetadataFile());
        }
    }

    @Override
    public String getIdentityURL() {
        if (this.identityURL == null && this.getIdentityURLProvider() != null) {
            this.identityURL = this.identityURLProvider.getDefaultUrl();
        }
        return this.identityURL;
    }

    public void setIdentityURLProvider(IdentityURLProviderType identityURLProvider) {
        this.identityURLProvider = identityURLProvider;
    }

    public IdentityURLProviderType getIdentityURLProvider() {
        return this.identityURLProvider;
    }
}

