/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import org.gatein.sso.saml.plugin.SimplePrincipal;

public class SimpleGroup
extends SimplePrincipal
implements Cloneable {
    private static final long serialVersionUID = 605185963957807247L;
    private HashMap members = new HashMap(3);

    public SimpleGroup(String groupName) {
        super(groupName);
    }

    public boolean addMember(Principal user) {
        boolean isMember = this.members.containsKey(user);
        if (!isMember) {
            this.members.put(user, user);
        }
        return !isMember;
    }

    public boolean isMember(Principal member) {
        boolean isMember = this.members.containsKey(member);
        if (!isMember) {
            Collection values = this.members.values();
            Iterator iter = values.iterator();
            while (!isMember && iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof SimpleGroup)) continue;
                SimpleGroup group = (SimpleGroup)next;
                isMember = group.isMember(member);
            }
        }
        return isMember;
    }

    public Enumeration<Principal> members() {
        return Collections.enumeration(this.members.values());
    }

    public boolean removeMember(Principal user) {
        Object prev = this.members.remove(user);
        return prev != null;
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        Iterator iter = this.members.keySet().iterator();
        while (iter.hasNext()) {
            tmp.append(iter.next());
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        SimpleGroup clone = (SimpleGroup)super.clone();
        if (clone != null) {
            clone.members = (HashMap)this.members.clone();
        }
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleGroup that = (SimpleGroup)o;
        return Objects.equals(this.members, that.members);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.members);
    }
}

