/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.sso.spnego;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.util.Base64;
import org.gatein.security.sso.spnego.SPNEGOSSOContext;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class SPNEGOSSOFilter
extends AbstractSSOInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSSOInterceptor.class);
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private LoginContext loginContext;
    private String[] patterns = new String[]{"/login", "/spnegosso"};
    private String loginServletPath = "/login";
    private String securityDomain = "spnego-server";

    protected void initImpl() {
        String domain;
        String loginServlet;
        String patternParam = this.getInitParameter("patterns");
        if (patternParam != null && !patternParam.isEmpty()) {
            this.patterns = patternParam.split(",");
        }
        if ((loginServlet = this.getInitParameter("loginServletPath")) != null && !loginServlet.isEmpty()) {
            this.loginServletPath = loginServlet;
        }
        if ((domain = this.getInitParameter("securityDomain")) != null && !domain.isEmpty()) {
            this.securityDomain = domain;
        }
        try {
            this.loginContext = new LoginContext(this.securityDomain);
        }
        catch (LoginException ex) {
            log.warn((Object)"Exception while init LoginContext, so SPNEGO SSO will not work", (Throwable)ex);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.isSpnegoLoginRequest(req)) {
            chain.doFilter(request, response);
            return;
        }
        SPNEGOSSOContext.setCurrentRequest(req);
        String contextPath = req.getContextPath();
        String loginURI = contextPath + this.loginServletPath;
        String requestURI = req.getRequestURI();
        String username = req.getParameter("username");
        String remoteUser = req.getRemoteUser();
        if (username != null || remoteUser != null) {
            if (!loginURI.equalsIgnoreCase(requestURI)) {
                StringBuilder login = new StringBuilder(loginURI);
                if (req.getQueryString() != null) {
                    login.append("?").append(req.getQueryString());
                }
                resp.sendRedirect(login.toString());
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
            return;
        }
        String principal = null;
        String auth = req.getHeader("Authorization");
        if (auth != null) {
            try {
                principal = this.login(req, resp, auth);
            }
            catch (Exception ex) {
                log.error((Object)"Exception occur when trying to login with SPNEGO", (Throwable)ex);
            }
        }
        if (principal != null && !principal.isEmpty()) {
            username = principal.substring(0, principal.indexOf(64));
            String password = UUID.randomUUID().toString();
            HttpSession session = req.getSession();
            session.setAttribute("SPNEGO_PRINCIPAL", (Object)username);
            StringBuilder login = new StringBuilder(loginURI).append("?username=").append(username).append("&password=").append(password);
            String initURL = req.getParameter("initialURI");
            if (initURL != null) {
                login.append("&initialURI=").append(initURL);
            }
            resp.sendRedirect(login.toString());
        } else {
            if (!loginURI.equals(requestURI)) {
                RequestDispatcher dispatcher = req.getRequestDispatcher("/login");
                dispatcher.include((ServletRequest)req, (ServletResponse)resp);
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.setStatus(401);
        }
    }

    private boolean isSpnegoLoginRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String context = request.getContextPath();
        for (String pattern : this.patterns) {
            if (!uri.equals(context.concat(pattern))) continue;
            return true;
        }
        return false;
    }

    private String login(HttpServletRequest req, HttpServletResponse resp, String auth) throws Exception {
        if (this.loginContext == null) {
            return null;
        }
        this.loginContext.login();
        String tok = auth.substring("Negotiate".length() + 1);
        byte[] gss = Base64.decode((String)tok);
        GSSContext context = null;
        byte[] token = null;
        context = MANAGER.createContext(SPNEGOSSOFilter.getServerCredential(this.loginContext.getSubject()));
        token = context.acceptSecContext(gss, 0, gss.length);
        if (null == token) {
            return null;
        }
        resp.setHeader("WWW-Authenticate", "Negotiate " + Base64.encodeBytes((byte[])token));
        if (!context.isEstablished()) {
            resp.setStatus(401);
            return null;
        }
        String principal = context.getSrcName().toString();
        context.dispose();
        this.loginContext.logout();
        return principal;
    }

    static GSSCredential getServerCredential(Subject subject) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return MANAGER.createCredential(null, Integer.MAX_VALUE, SPNEGOSSOFilter.getOid(), 2);
            }
        };
        return Subject.doAs(subject, action);
    }

    private static Oid getOid() {
        Oid oid = null;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gsse) {
            gsse.printStackTrace();
        }
        return oid;
    }

    public void destroy() {
    }
}

