/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.calendar;

import java.util.Date;
import java.util.LinkedList;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.storage.EventDAO;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.calendar.TasksCalendarDAOImpl;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.TaskUtil;

public class TasksEventDAOImpl
implements EventDAO {
    private TaskService taskService;
    private static final Log LOG = ExoLogger.getExoLogger(TasksCalendarDAOImpl.class);

    public TasksEventDAOImpl(TaskService taskService) {
        this.taskService = taskService;
    }

    public Event getById(String id) {
        try {
            Task task = this.taskService.getTask(Long.valueOf(id).longValue());
            if (task.getStartDate() != null) {
                if (task.isCalendarIntegrated()) {
                    Event event = this.newInstance();
                    return TaskUtil.buildEvent((Event)event, (Task)task);
                }
            } else {
                LOG.warn("Can't map task: {} to event due to no workplan", new Object[]{id});
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public ListAccess<Event> findEventsByQuery(EventQuery query) {
        LinkedList<Long> ids = new LinkedList<Long>();
        if (query.getCalendarIds() != null) {
            for (String calId : query.getCalendarIds()) {
                try {
                    Long id = Long.valueOf(calId);
                    ids.add(id);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        LinkedList<OrderBy> orderBy = new LinkedList<OrderBy>();
        if (query.getOrderBy() != null) {
            boolean ascending = "ascending".equals(query.getOrderType());
            for (String by : query.getOrderBy()) {
                by = "exo:summary".equals(by) ? "title" : ("exo:description".equals(by) ? "description" : ("exo:fromDateTime".equals(by) ? "startDate" : ("exo:toDateTime".equals(by) ? "endDate" : ("exo:priority".equals(by) ? "priority" : null))));
                if (by == null) continue;
                orderBy.add(new OrderBy(by, ascending));
            }
        }
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setOrderBy(orderBy);
        if (query.getFromDate() != null) {
            taskQuery.setStartDate(new Date(query.getFromDate()));
        }
        if (query.getToDate() != null) {
            taskQuery.setEndDate(new Date(query.getToDate()));
        }
        taskQuery.setKeyword(query.getText());
        taskQuery.setCalendarIntegrated(Boolean.valueOf(true));
        taskQuery.setAssigneeOrInProject(query.getOwner(), ids);
        Task[] tasks = new Task[]{};
        if ((query.getCategoryIds() == null || query.getCategoryIds().length == 1 && query.getCategoryIds()[0].equals("defaultEventCategoryIdAll")) && (query.getEventType() == null || query.getEventType().equals(Event.TYPE_TASK))) {
            tasks = (Task[])ListUtil.load((ListAccess)this.taskService.findTasks(taskQuery), (int)0, (int)-1);
        }
        final LinkedList<Event> events = new LinkedList<Event>();
        for (Task t : tasks) {
            Event event = this.newInstance();
            events.add(TaskUtil.buildEvent((Event)event, (Task)t));
            if (event.getCalendarId() != null && (ids.contains(Long.valueOf(event.getCalendarId())) || !ids.contains(-2L))) continue;
            event.setCalendarId(String.valueOf(-2));
        }
        return new ListAccess<Event>(){

            public int getSize() throws Exception {
                return events.size();
            }

            public Event[] load(int offset, int limit) throws Exception, IllegalArgumentException {
                return (Event[])Utils.subArray((Object[])events.toArray(new Event[this.getSize()]), (int)offset, (int)limit);
            }
        };
    }

    public Event save(Event event) {
        throw new UnsupportedOperationException();
    }

    public Event update(Event event) {
        throw new UnsupportedOperationException();
    }

    public Event remove(String id) {
        throw new UnsupportedOperationException();
    }

    public Event newInstance() {
        Event event = new Event();
        return event;
    }
}

