/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.integration.notification.TemplateUtils;
import org.exoplatform.task.service.UserService;

@TemplateConfigs(templates={@TemplateConfig(pluginId="TaskAssignPlugin", template="war:/notification/templates/mail/TaskAssignPlugin.gtmpl"), @TemplateConfig(pluginId="TaskCoworkerPlugin", template="war:/notification/templates/mail/TaskCoworkerPlugin.gtmpl"), @TemplateConfig(pluginId="TaskDueDatePlugin", template="war:/notification/templates/mail/TaskDueDatePlugin.gtmpl"), @TemplateConfig(pluginId="TaskCompletedPlugin", template="war:/notification/templates/mail/TaskCompletedPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"TaskAssignPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskCoworkerPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskDueDatePlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskCompletedPlugin"), new TemplateBuilder());
    }

    public static String getExcerpt(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() > len) {
            str = str.substring(0, len);
            int lastSpace = str.lastIndexOf(" ");
            return (lastSpace > 0 ? str.substring(0, lastSpace) : str) + "...";
        }
        return str;
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String creator = notification.getValueOwnerParameter(NotificationUtils.CREATOR.getKey());
            String projectName = notification.getValueOwnerParameter("projectName");
            String taskTitle = notification.getValueOwnerParameter("taskName");
            String taskDesc = notification.getValueOwnerParameter("taskDescription");
            String taskUrl = notification.getValueOwnerParameter("taskUrl");
            String projectUrl = notification.getValueOwnerParameter("projectUrl");
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            Identity author = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", creator, true);
            Profile profile = author.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)author.getRemoteId()));
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"PROJECT_NAME", (Object)(projectName == null ? "" : encoder.encode(projectName)));
            templateContext.put((Object)"TASK_TITLE", (Object)encoder.encode(taskTitle));
            templateContext.put((Object)"TASK_DESCRIPTION", (Object)encoder.encode(MailTemplateProvider.getExcerpt(taskDesc, 130)));
            templateContext.put((Object)"DUE_DATE", (Object)this.getDueDate(notification));
            templateContext.put((Object)"TASK_URL", (Object)taskUrl);
            templateContext.put((Object)"PROJECT_URL", (Object)projectUrl);
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = org.exoplatform.commons.notification.template.TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = org.exoplatform.commons.notification.template.TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        private String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap<String, LinkedList<NotificationInfo>> map = new HashMap<String, LinkedList<NotificationInfo>>();
            for (NotificationInfo notif : notifications) {
                String activityID = notif.getValueOwnerParameter("activityId");
                LinkedList<NotificationInfo> tmp = (LinkedList<NotificationInfo>)map.get(activityID);
                if (tmp == null) {
                    tmp = new LinkedList<NotificationInfo>();
                    map.put(activityID, tmp);
                }
                tmp.add(notif);
            }
            StringBuilder sb = new StringBuilder();
            for (String activityID : map.keySet()) {
                List notifs = (List)map.get(activityID);
                NotificationInfo first = (NotificationInfo)notifs.get(0);
                String taskUrl = first.getValueOwnerParameter("taskUrl");
                String projectUrl = first.getValueOwnerParameter("projectUrl");
                String projectName = first.getValueOwnerParameter("projectName");
                if (projectName != null && !projectName.isEmpty()) {
                    PluginConfig config = ((PluginSettingService)CommonsUtils.getService(PluginSettingService.class)).getPluginConfig(templateContext.getPluginId());
                    String resourcePath = config.getBundlePath();
                    Locale locale = org.exoplatform.commons.notification.NotificationUtils.getLocale((String)templateContext.getLanguage());
                    String inProject = org.exoplatform.commons.notification.template.TemplateUtils.getResourceBundle((String)"Notification.message.inProject", (Locale)locale, (String)resourcePath);
                    templateContext.put((Object)"PROJECT_NAME", (Object)inProject.replace("{0}", "<a href=\"" + projectUrl + "\" style=\"text-decoration: none; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif\"><strong>" + encoder.encode(projectName) + "</strong></a>"));
                } else {
                    templateContext.put((Object)"PROJECT_NAME", (Object)"");
                }
                String taskTitle = "";
                if (notifs.size() == 1) {
                    taskTitle = first.getValueOwnerParameter("taskName");
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                } else {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_MORE.getValue());
                }
                templateContext.put((Object)"TASK_TITLE", (Object)("<a href=\"" + taskUrl + "\" style=\"text-decoration: none; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif\">" + encoder.encode(MailTemplateProvider.getExcerpt(taskTitle, 30)) + "</a>"));
                templateContext.put((Object)"COUNT", (Object)("<a href=\"" + projectUrl + "\" style=\"text-decoration: none; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif\">" + String.valueOf(notifs.size()) + "</a>"));
                templateContext.put((Object)"DUE_DATE", (Object)this.getDueDate(first));
                sb.append("<li style=\"margin:0 0 13px 14px;font-size:13px;line-height:18px;font-family:HelveticaNeue,Helvetica,Arial,sans-serif\"><div style=\"color: #333;\">");
                String digester = org.exoplatform.commons.notification.template.TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }

        private String getDueDate(NotificationInfo notification) {
            String dueDate = notification.getValueOwnerParameter("dueDate");
            if (dueDate != null) {
                Date date = new Date(Long.parseLong(dueDate));
                UserService userService = (UserService)CommonsUtils.getService(UserService.class);
                return TemplateUtils.format(date, userService.getUserTimezone(notification.getTo()));
            }
            return "";
        }
    }
}

