/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.ResourceUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.UserUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;

public class ProjectSearchConnector
extends SearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(ProjectSearchConnector.class);
    private ProjectService projectService;
    private WebAppController controller;

    public ProjectSearchConnector(InitParams initParams, ProjectService projectService, WebAppController controller) {
        super(initParams);
        this.projectService = projectService;
        this.controller = controller;
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (query == null || query.trim().isEmpty()) {
            return result;
        }
        query = StringUtil.FUZZY.matcher(query.trim()).replaceAll("");
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        ListAccess tmp = this.projectService.findProjects(UserUtil.getMemberships((Identity)currentUser), query, this.buildOrderBy(sort, order));
        List<Object> projects = new LinkedList();
        try {
            projects = Arrays.asList(tmp.load(0, -1));
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't load project list", (Throwable)ex);
        }
        for (Project project : projects) {
            result.add(this.buildResult(project, context));
        }
        return ResourceUtil.subList(result, (int)offset, (int)limit);
    }

    private SearchResult buildResult(Project p, SearchContext ctx) {
        String detail = p.getDescription();
        String url = this.buildUrl(p, ctx);
        String imageUrl = this.buildImageUrl(p);
        return new SearchResult(url, p.getName(), "", detail, imageUrl, p.getDueDate().getTime(), 0L);
    }

    private String buildImageUrl(Project p) {
        return null;
    }

    private String buildUrl(Project p, SearchContext context) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return ProjectUtil.buildProjectURL((Project)p, (SiteKey)SiteKey.portal((String)context.getSiteName()), (ExoContainer)container, (Router)this.controller.getRouter());
    }

    private OrderBy buildOrderBy(String sort, String order) {
        String orderBy = null;
        if ("date".equals(sort)) {
            orderBy = "dueDate";
        } else if ("title".equals(sort)) {
            orderBy = "name";
        }
        if (orderBy != null) {
            if ("asc".equals(order)) {
                return new OrderBy.ASC(orderBy);
            }
            return new OrderBy.DESC(orderBy);
        }
        return null;
    }
}

