/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.chat;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.ui.ActionContext;
import org.exoplatform.commons.api.ui.BaseUIPlugin;
import org.exoplatform.commons.api.ui.RenderContext;
import org.exoplatform.commons.api.ui.Response;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.ActivityTaskProcessor;
import org.exoplatform.task.legacy.service.ParserContext;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.StatusService;
import org.exoplatform.task.legacy.service.TaskParser;
import org.exoplatform.task.legacy.service.TaskService;
import org.exoplatform.task.legacy.service.UserService;
import org.exoplatform.task.model.User;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.TaskUtil;
import org.json.simple.JSONObject;

public class ChatPopupPlugin
extends BaseUIPlugin {
    private static final String PREFIX = "++";
    private static Log log = ExoLogger.getExoLogger(ChatPopupPlugin.class);
    private static final String TYPE = "type";
    private static final String CREATE_TASK_ACTION = "createTask";
    private static final String CREATE_TASK_INLINE_ACTION = "createTaskInline";
    private ProjectService projectService;
    private StatusService statusService;
    private SpaceService spaceService;
    private TaskService taskService;
    private UserService userService;
    private TaskParser taskParser;
    private String pluginType = "chat_extension_popup";
    private SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");

    public ChatPopupPlugin(InitParams params, ProjectService projectService, StatusService statusService, SpaceService spaceService, TaskService taskService, UserService userService, TaskParser taskParser) {
        this.projectService = projectService;
        this.statusService = statusService;
        this.taskService = taskService;
        this.spaceService = spaceService;
        this.userService = userService;
        this.taskParser = taskParser;
        ValueParam param = params.getValueParam(TYPE);
        if (param != null) {
            this.pluginType = param.getValue();
        }
    }

    public Response render(RenderContext renderContext) {
        return new Response(new byte[0], "text/plain");
    }

    public Response processAction(ActionContext context) {
        Map params = context.getParams();
        String actionName = context.getName();
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        String taskInput = this.getParam("text", params);
        String dueDateInput = this.getParam("dueDate", params);
        Status status = this.getStatus(params);
        if (CREATE_TASK_ACTION.equals(actionName)) {
            String username = this.getParam("username", params);
            username = StringUtils.isEmpty((String)username) ? creator : username;
            this.sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            Date dueDate = null;
            if (StringUtils.isNotBlank((String)dueDateInput)) {
                try {
                    dueDate = this.sdf.parse(dueDateInput + " 23:59");
                }
                catch (Exception ex) {
                    log.error((Object)("Cannot parse due date " + dueDateInput + " : " + ex.getMessage()), (Throwable)ex);
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            byte[] result = null;
            for (String name : username.split(",")) {
                Task task = new Task();
                task.setAssignee(name);
                task.setTitle(taskInput);
                task.setDueDate(dueDate);
                task.setCreatedBy(creator);
                task.setCreatedTime(new Date());
                task.setStatus(status);
                task = this.taskService.createTask(task);
                try {
                    result = mapper.writeValueAsBytes((Object)this.buildJSON(task));
                }
                catch (Exception e) {
                    log.error((Object)"Problem when adding task in chat", (Throwable)e);
                    return null;
                }
            }
            return new Response(result, "application/json");
        }
        if (CREATE_TASK_INLINE_ACTION.equals(actionName)) {
            ParserContext parserCtx = new ParserContext(this.userService.getUserTimezone(creator));
            Task task = this.parseText(taskInput, parserCtx);
            if (task != null) {
                task.setCreatedBy(creator);
                task.setCreatedTime(new Date());
                task.setStatus(status);
                this.taskService.createTask(task);
                return new Response(this.buildJSON(task).toJSONString().getBytes(), "application/json");
            }
            return null;
        }
        return null;
    }

    private JSONObject buildJSON(Task task) {
        User user;
        JSONObject json = new JSONObject();
        json.put((Object)"title", (Object)task.getTitle());
        json.put((Object)"url", (Object)TaskUtil.buildTaskURL((Task)task));
        if (task.getAssignee() != null && (user = this.userService.loadUser(task.getAssignee())) != null) {
            json.put((Object)"assignee", (Object)user.getUsername());
            json.put((Object)"fullName", (Object)String.format("%s %s", user.getFirstName(), user.getLastName()));
        }
        if (task.getDueDate() != null) {
            json.put((Object)"dueDate", (Object)this.sdf.format(task.getDueDate()));
        }
        return json;
    }

    private Status getStatus(Map<String, List<String>> params) {
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        String roomName = this.getParam("roomName", params);
        String isSpace = this.getParam("isSpace", params);
        String isTeam = this.getParam("isTeam", params);
        String participants = this.getParam("participants", params);
        Project project = null;
        if ("true".equals(isSpace)) {
            log.debug("creating task in space {}", new Object[]{roomName});
            if (StringUtils.isNotEmpty((String)roomName)) {
                Space space = this.spaceService.getSpaceByPrettyName(roomName);
                if (space != null) {
                    List projects = ProjectUtil.getProjectTree((String)space.getGroupId(), (ProjectService)this.projectService);
                    if (projects != null && projects.size() > 0) {
                        project = (Project)projects.get(0);
                    } else {
                        log.warn("no project found for space {}, task will be created as incoming", new Object[]{space.getId()});
                    }
                } else {
                    log.warn("space {} is null, can't add task to space's default project", new Object[]{roomName});
                }
            }
        } else if ("true".equals(isTeam)) {
            log.debug("creating task in team project {}", new Object[]{roomName});
            ProjectQuery query = new ProjectQuery();
            query.setKeyword(roomName);
            ListAccess projects = this.projectService.findProjects(query);
            try {
                if (projects.getSize() > 0) {
                    project = ((Project[])projects.load(0, 1))[0];
                } else {
                    HashSet<String> mans = new HashSet<String>(Arrays.asList(creator));
                    HashSet<String> pars = new HashSet<String>(Arrays.asList(participants.split(",")));
                    project = ProjectUtil.newProjectInstance((String)roomName, (String)"", mans, pars);
                    this.projectService.createProject(project);
                    this.statusService.createInitialStatuses(project);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (project != null) {
            return this.statusService.getDefaultStatus(project.getId());
        }
        return null;
    }

    private String getParam(String name, Map<String, List<String>> params) {
        if (params.get(name) != null && params.get(name).size() > 0) {
            return params.get(name).get(0);
        }
        return null;
    }

    public String getType() {
        return this.pluginType;
    }

    private Task parseText(String txt, ParserContext context) {
        int idx;
        if (txt != null && !txt.isEmpty() && (idx = txt.indexOf(PREFIX)) >= 0 && idx + 2 < txt.length() - 1) {
            String description;
            String title;
            txt = ActivityTaskProcessor.decode(txt);
            txt = StringEscapeUtils.unescapeHtml((String)txt);
            String text = txt.substring(idx + 2);
            int index = (text = text.replaceFirst("<br(\\s*\\/?)>", "\n")).indexOf("\n");
            if (index > 1) {
                title = text.substring(0, index);
                description = text.substring(index).trim();
            } else {
                title = text.trim();
                description = "";
            }
            Task task = this.taskParser.parse(title, context);
            task.setDescription(StringUtil.encodeInjectedHtmlTag((String)description));
            return task;
        }
        return null;
    }
}

