/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.MapAttribute;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.PathImplementor;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;

public class MapEntryExpression<K, V>
extends ExpressionImpl<Map.Entry<K, V>>
implements Expression<Map.Entry<K, V>>,
Serializable {
    private final PathImplementor origin;
    private final MapAttribute<?, K, V> attribute;

    public MapEntryExpression(CriteriaBuilderImpl criteriaBuilder, Class<Map.Entry<K, V>> javaType, PathImplementor origin, MapAttribute<?, K, V> attribute) {
        super(criteriaBuilder, javaType);
        this.origin = origin;
        this.attribute = attribute;
    }

    public MapAttribute<?, K, V> getAttribute() {
        return this.attribute;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        throw new IllegalStateException("illegal reference to map entry outside of select clause.");
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return "entry(" + this.path(renderingContext) + ")";
    }

    private String path(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.origin.getPathIdentifier() + '.' + ((Renderable)this.getAttribute()).renderProjection(renderingContext);
    }
}

