/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;
import org.hibernate.ejb.criteria.expression.function.FunctionExpression;

public class ParameterizedFunctionExpression<X>
extends BasicFunctionExpression<X>
implements FunctionExpression<X> {
    private final List<Expression<?>> argumentExpressions;

    public ParameterizedFunctionExpression(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName, List<Expression<?>> argumentExpressions) {
        super(criteriaBuilder, javaType, functionName);
        this.argumentExpressions = argumentExpressions;
    }

    public ParameterizedFunctionExpression(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName, Expression<?> ... argumentExpressions) {
        super(criteriaBuilder, javaType, functionName);
        this.argumentExpressions = Arrays.asList(argumentExpressions);
    }

    protected static List<Expression<?>> wrapAsLiterals(CriteriaBuilderImpl criteriaBuilder, Object ... literalArguments) {
        ArrayList arguments = new ArrayList(ParameterizedFunctionExpression.properSize(literalArguments.length));
        for (Object o : literalArguments) {
            arguments.add(new LiteralExpression<Object>(criteriaBuilder, o));
        }
        return arguments;
    }

    protected static int properSize(int number) {
        return number + (int)((double)number * 0.75) + 1;
    }

    public List<Expression<?>> getArgumentExpressions() {
        return this.argumentExpressions;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (Expression<?> argument : this.getArgumentExpressions()) {
            if (!ParameterContainer.class.isInstance(argument)) continue;
            ((ParameterContainer)argument).registerParameters(registry);
        }
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getFunctionName()).append('(');
        this.renderArguments(buffer, renderingContext);
        buffer.append(')');
        return buffer.toString();
    }

    protected void renderArguments(StringBuilder buffer, CriteriaQueryCompiler.RenderingContext renderingContext) {
        String sep = "";
        for (Expression<?> argument : this.argumentExpressions) {
            buffer.append(sep).append(((Renderable)argument).render(renderingContext));
            sep = ", ";
        }
    }
}

