/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.domain.Status;

public class StatusDAOImpl
extends GenericDAOJPAImpl<Status, Long>
implements StatusHandler {
    private EntityManagerService entityService;

    public StatusDAOImpl(EntityManagerService entityService) {
        this.entityService = entityService;
    }

    public EntityManager getEntityManager() {
        return this.entityService.getEntityManager();
    }

    @Override
    public Status findLowestRankStatusByProject(Long projectId) {
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("Status.findLowestRankStatusByProject", Status.class);
        query.setParameter("projectId", (Object)projectId);
        return (Status)query.getSingleResult();
    }

    @Override
    public Status findHighestRankStatusByProject(long projectId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", projectId);
        List<Status> sts = this.findByNamedQuery("Status.findHighestRankStatusByProject", params);
        if (!sts.isEmpty()) {
            return sts.get(0);
        }
        return null;
    }

    @Override
    public Status findByName(String name, long projectID) {
        if (!StringUtils.isNotEmpty((String)name)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("projectID", projectID);
        List<Status> sts = this.findByNamedQuery("Status.findByName", params);
        if (!sts.isEmpty()) {
            return sts.get(0);
        }
        return null;
    }

    public List<Status> findByNamedQuery(String query, Map<String, Object> params) {
        EntityManager em = this.getEntityManager();
        TypedQuery q = em.createNamedQuery(query, Status.class);
        if (params != null) {
            for (Map.Entry<String, Object> p : params.entrySet()) {
                q.setParameter(p.getKey(), p.getValue());
            }
        }
        return q.getResultList();
    }
}

