/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;

@Entity
@Table(name="TASK_STATUS")
@NamedQueries(value={@NamedQuery(name="Status.findLowestRankStatusByProject", query="SELECT s FROM Status s WHERE s.rank = (SELECT MIN(s2.rank) FROM Status s2 WHERE s2.project.id = :projectId) AND s.project.id = :projectId)"), @NamedQuery(name="Status.findHighestRankStatusByProject", query="SELECT s FROM Status s WHERE s.rank = (SELECT MAX(s2.rank) FROM Status s2 WHERE s2.project.id = :projectId) AND s.project.id = :projectId)"), @NamedQuery(name="Status.findByName", query="SELECT s FROM Status s WHERE s.name = :name AND s.project.id = :projectID)")})
public class Status
implements Comparable<Status> {
    @Id
    @GeneratedValue
    @Column(name="STATUS_ID")
    private long id;
    private String name;
    private Integer rank;
    @OneToMany(mappedBy="status", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Task> tasks = new HashSet<Task>();
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private Project project;

    public Status() {
    }

    public Status(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public Status(long id, String name, Integer rank, Set<Task> tasks, Project project) {
        this.id = id;
        this.name = name;
        this.rank = rank;
        this.tasks = tasks;
        this.project = project;
    }

    public Status(String name, Integer rank, Set<Task> tasks, Project project) {
        this.name = name;
        this.rank = rank;
        this.tasks = tasks;
        this.project = project;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Set<Task> tasks) {
        this.tasks = tasks;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Status clone(boolean cloneTask) {
        Status status = new Status(this.getName(), this.getRank(), new HashSet<Task>(), null);
        if (cloneTask && this.getTasks() != null) {
            for (Task t : this.getTasks()) {
                if (t.isCompleted()) continue;
                Task cloned = t.clone();
                status.getTasks().add(cloned);
                cloned.setStatus(status);
            }
        }
        return status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        if (this.id != status.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(status.name) : status.name != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(status.project) : status.project != null) {
            return false;
        }
        if (this.rank != null ? !this.rank.equals(status.rank) : status.rank != null) {
            return false;
        }
        return !(this.tasks != null ? !this.tasks.equals(status.tasks) : status.tasks != null);
    }

    @Override
    public int compareTo(Status o) {
        if (this.getRank() == null) {
            return o.getRank() == null ? 0 : -1;
        }
        if (o.getRank() == null) {
            return 1;
        }
        return this.getRank().compareTo(o.getRank());
    }
}

