/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.impl.ProjectServiceImpl;
import org.exoplatform.task.service.impl.StatusServiceImpl;
import org.exoplatform.task.utils.UserUtils;

public class SpaceTaskDataInitializer
extends SpaceListenerPlugin {
    private static final Log log = ExoLogger.getExoLogger(SpaceTaskDataInitializer.class);
    private ProjectService projectService;

    public SpaceTaskDataInitializer(DAOHandler daoHandler) {
        StatusServiceImpl statusService = new StatusServiceImpl(daoHandler);
        this.projectService = new ProjectServiceImpl(statusService, null, daoHandler);
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String space_group_id = space.getGroupId();
        List<String> memberships = UserUtils.getSpaceMemberships(space_group_id);
        HashSet<String> managers = new HashSet<String>(Arrays.asList(memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList(memberships.get(1)));
        try {
            this.projectService.createDefaultStatusProjectWithAttributes(0L, space.getDisplayName(), "", managers, participators);
        }
        catch (ProjectNotFoundException e) {
            log.error((Object)e);
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }
}

