/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskService;

public class TaskEvent {
    private TaskService context;
    private Type type;
    private Task task;
    private Object oldVal;
    private Object newVal;

    private TaskEvent(TaskService context, Type type, Task task, Object oldVal, Object newVal) {
        this.type = type;
        this.task = task;
        this.oldVal = oldVal;
        this.newVal = newVal;
        this.context = context;
    }

    public Type getType() {
        return this.type;
    }

    public Task getTask() {
        return this.task;
    }

    public Object getOldVal() {
        return this.oldVal;
    }

    public Object getNewVal() {
        return this.newVal;
    }

    public TaskService getContext() {
        return this.context;
    }

    public static class EventBuilder {
        private Type type;
        private Task task;
        private Object oldVal;
        private Object newVal;
        private TaskService context;

        public EventBuilder(TaskService context) {
            this.context = context;
        }

        public EventBuilder withType(Type type) {
            this.type = type;
            return this;
        }

        public EventBuilder withTask(Task task) {
            this.task = task;
            return this;
        }

        public EventBuilder withOldVal(Object oldVal) {
            this.oldVal = oldVal;
            return this;
        }

        public EventBuilder withNewVal(Object newVal) {
            this.newVal = newVal;
            return this;
        }

        public TaskEvent build() {
            return new TaskEvent(this.context, this.type, this.task, this.oldVal, this.newVal);
        }
    }

    public static enum Type {
        CREATED,
        EDIT_TITLE,
        EDIT_DESCRIPTION,
        EDIT_DUEDATE,
        EDIT_PROJECT,
        EDIT_ASSIGNEE,
        EDIT_STATUS,
        ADD_LABEL,
        EDIT_WORKPLAN,
        ADD_SUBTASK,
        MARK_DONE;

    }
}

