/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.utils;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.utils.UserUtils;

public final class ProjectUtil {
    private static final Log LOG = ExoLogger.getExoLogger(ProjectUtil.class);
    public static final int INCOMING_PROJECT_ID = -1;
    public static final int TODO_PROJECT_ID = -2;

    private ProjectUtil() {
    }

    public static List<Project> getProjectTree(String space_group_id, ProjectService projectService) {
        LinkedList<String> memberships = new LinkedList<String>();
        if (space_group_id == null) {
            ConversationState state = ConversationState.getCurrent();
            Identity identity = state.getIdentity();
            memberships.addAll(UserUtils.getMemberships(identity));
        } else {
            memberships.addAll(UserUtils.getSpaceMemberships(space_group_id));
        }
        return projectService.getProjectTreeByMembership(memberships);
    }

    public static List<Project> buildRootProjects(List<Project> projects) {
        LinkedList<Project> tmpParents;
        if (projects == null) {
            return projects;
        }
        LinkedHashSet<Project> rootPRJs = new LinkedHashSet<Project>();
        LinkedHashSet<Project> childs = new LinkedHashSet<Project>();
        block0: for (Project p : projects) {
            while (true) {
                Project parent;
                if ((parent = p.getParent()) == null) {
                    rootPRJs.add(p);
                    continue block0;
                }
                childs.add(p);
                p = parent;
            }
        }
        LinkedList parents = new LinkedList(rootPRJs);
        do {
            tmpParents = new LinkedList<Project>();
            for (Project p : parents) {
                LinkedList<Project> tmp = new LinkedList<Project>();
                for (Project c : childs) {
                    if (!c.getParent().equals(p)) continue;
                    tmp.add(c);
                }
                p.setChildren(tmp);
                tmpParents.addAll(tmp);
                childs.removeAll(tmp);
            }
        } while (!(parents = tmpParents).isEmpty() && !childs.isEmpty());
        return new LinkedList<Project>(rootPRJs);
    }

    public static String buildBreadcumbs(Long id, ProjectService projectService, ResourceBundle bundle) {
        StringBuilder el;
        Project project = null;
        try {
            project = projectService.getProjectById(id);
        }
        catch (ProjectNotFoundException e) {
            LOG.warn("project {} not found", new Object[]{id});
        }
        StringBuilder builder = new StringBuilder();
        if (project != null) {
            for (Project tmp = project; tmp != null; tmp = tmp.getParent()) {
                el = new StringBuilder();
                if (builder.length() == 0) {
                    el.append("<li class=\"active\">").append(tmp.getName()).append("</li>");
                } else {
                    el.append("<li>").append("<a class=\"Selected\" title=\"\" data-placement=\"bottom\" rel=\"tooltip\" href=\"#\" data-original-title=\"").append(tmp.getName()).append("\">").append(tmp.getName()).append("</a>").append("<span class=\"uiIconMiniArrowRight\"></span>").append("</li>");
                }
                builder.insert(0, el.toString());
            }
        }
        String label = bundle.getString("label.projects");
        el = new StringBuilder();
        if (builder.length() == 0) {
            el.append("<li class=\"active\">").append(label).append("</li>");
        } else {
            el.append("<li>").append("<a class=\"Selected\" title=\"\" data-placement=\"bottom\" rel=\"tooltip\" href=\"#\" data-original-title=\"").append(label).append("\">").append(label).append("</a>").append("<span class=\"uiIconMiniArrowRight\"></span>").append("</li>");
        }
        builder.insert(0, el.toString());
        return builder.toString();
    }
}

