/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
public class FilterUrlByProtocolAttributePolicy
implements AttributePolicy {
    private final ImmutableSet<String> protocols;

    public FilterUrlByProtocolAttributePolicy(Iterable<? extends String> protocols) {
        this.protocols = ImmutableSet.copyOf(protocols);
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, String s) {
        int n = s.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (s.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    if (!s.startsWith("//") || this.allowProtocolRelativeUrls()) break block4;
                    return null;
                }
                case ':': {
                    String protocol = Strings.toLowerCase(s.substring(0, i));
                    if (this.protocols.contains((Object)protocol)) break block4;
                    return null;
                }
                default: {
                    continue block4;
                }
            }
        }
        return FilterUrlByProtocolAttributePolicy.normalizeUri(s);
    }

    protected boolean allowProtocolRelativeUrls() {
        return this.protocols.contains((Object)"http") && this.protocols.contains((Object)"https");
    }

    static String normalizeUri(String s) {
        int n = s.length();
        boolean colonsIrrelevant = false;
        block5: for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '#': 
                case '/': 
                case ':': 
                case '?': {
                    colonsIrrelevant = true;
                    continue block5;
                }
                case '(': 
                case ')': 
                case '{': 
                case '}': {
                    return FilterUrlByProtocolAttributePolicy.normalizeUriFrom(s, i, colonsIrrelevant);
                }
                case '\u0589': 
                case '\u05c3': 
                case '\u2236': 
                case '\uff1a': {
                    if (colonsIrrelevant) continue block5;
                    return FilterUrlByProtocolAttributePolicy.normalizeUriFrom(s, i, false);
                }
            }
        }
        return s;
    }

    private static String normalizeUriFrom(String s, int start, boolean colonsIrrelevant) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 16);
        int pos = 0;
        for (int i = start; i < n; ++i) {
            char ch = s.charAt(i);
            String repl = null;
            block0 : switch (ch) {
                case '(': {
                    repl = "%28";
                    break;
                }
                case ')': {
                    repl = "%29";
                    break;
                }
                case '{': {
                    repl = "%7b";
                    break;
                }
                case '}': {
                    repl = "%7d";
                    break;
                }
                default: {
                    if (ch < '\u0100' || colonsIrrelevant) break;
                    switch (ch) {
                        case '\u0589': {
                            repl = "%d6%89";
                            break block0;
                        }
                        case '\u05c3': {
                            repl = "%d7%83";
                            break block0;
                        }
                        case '\u2236': {
                            repl = "%e2%88%b6";
                            break block0;
                        }
                        case '\uff1a': {
                            repl = "%ef%bc%9a";
                        }
                    }
                }
            }
            if (repl == null) continue;
            sb.append(s, pos, i).append(repl);
            pos = i + 1;
        }
        return sb.append(s, pos, n).toString();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.protocols.equals(((FilterUrlByProtocolAttributePolicy)o).protocols);
    }

    public int hashCode() {
        return this.protocols.hashCode();
    }
}

