/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.util.StringTokenizer;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.StringUtil;

public final class CommentUtil {
    private CommentUtil() {
    }

    public static String formatMention(String text, UserService userService) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreElements()) {
            User user;
            String username;
            String next = (String)tokenizer.nextElement();
            if (next.length() == 0) continue;
            if (next.charAt(0) == '@') {
                username = next.substring(1);
                user = userService.loadUser(username);
                if (user != null && !"guest".equals(user.getUsername())) {
                    next = "<a href=\"" + user.getUrl() + "\">" + encoder.encodeHTML(user.getDisplayName()) + "</a>";
                }
            } else if (next.startsWith("<p>@")) {
                username = next.substring(4);
                user = userService.loadUser(username);
                if (user != null && !"guest".equals(user.getUsername())) {
                    next = "<p><a href=\"" + user.getUrl() + "\">" + encoder.encodeHTML(user.getDisplayName()) + "</a>";
                }
            } else if (next.contains("@") && (user = userService.loadUser(username = next.split("@")[1])) != null && !"guest".equals(user.getUsername())) {
                next = next.split("@")[0] + "<a href=\"" + user.getUrl() + "\">" + encoder.encodeHTML(user.getDisplayName()) + "</a>";
            }
            sb.append(next);
            sb.append(' ');
        }
        return StringUtil.encodeInjectedHtmlTag(sb.toString());
    }
}

