/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.dao.LabelQuery;
import org.exoplatform.task.dao.jpa.CommonJPADAO;
import org.exoplatform.task.dao.jpa.JPAQueryListAccess;
import org.exoplatform.task.domain.Label;

public class LabelDAOImpl
extends CommonJPADAO<Label, Long>
implements LabelHandler {
    public void delete(Label entity) {
        Query query = this.getEntityManager().createNamedQuery("LabelTaskMapping.removeLabelTaskMapping");
        query.setParameter("labelId", (Object)entity.getId());
        query.executeUpdate();
        List<Label> children = entity.getChildren();
        if (children != null) {
            for (Label child : children) {
                this.delete(child);
            }
        }
        super.delete((Object)entity);
    }

    public void deleteAll(List<Label> entities) {
        for (Label lb : entities) {
            this.delete(lb);
        }
    }

    public void deleteAll() {
        this.deleteAll(this.findAll());
    }

    @Override
    public ListAccess<Label> findLabelsByUser(String username) {
        LabelQuery query = new LabelQuery();
        query.setUserName(username);
        return this.findLabels(query);
    }

    @Override
    public ListAccess<Label> findLabelsByTask(long taskId, String username) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Label.findLabelsByTask", Label.class);
        query.setParameter("username", (Object)username);
        query.setParameter("taskid", (Object)taskId);
        TypedQuery count = this.getEntityManager().createNamedQuery("Label.findLabelsByTaskCount", Long.class);
        count.setParameter("username", (Object)username);
        count.setParameter("taskid", (Object)taskId);
        return new JPAQueryListAccess<Label>(Label.class, (TypedQuery<Long>)count, query);
    }

    @Override
    public ListAccess<Label> findLabels(LabelQuery query) {
        return this.findEntities(query, Label.class);
    }
}

