/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.calendar;

import org.exoplatform.calendar.model.Event;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.task.domain.Task;

public class CalendarIntegrationUtil {
    private CalendarIntegrationUtil() {
    }

    public static Event buildEvent(Event event, Task task) {
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        if (task.getStatus() != null) {
            event.setCalendarId(String.valueOf(task.getStatus().getProject().getId()));
            event.setEventState(encoder.encode(task.getStatus().getName()));
        } else {
            event.setCalendarId(String.valueOf(-2L));
        }
        event.setDescription(task.getDescription());
        event.setEventCategoryId("defaultEventCategoryIdAll");
        event.setEventCategoryName("defaultEventCategoryNameAll");
        event.setEventType(Event.TYPE_TASK);
        if (task.getStartDate() == null) {
            throw new IllegalStateException("Can't build event with a task that doesn't have workplan");
        }
        event.setFromDateTime(task.getStartDate());
        event.setToDateTime(task.getEndDate());
        event.setId(String.valueOf(task.getId()));
        if (task.getPriority() != null) {
            switch (task.getPriority()) {
                case HIGH: {
                    event.setPriority(Event.PRIORITY_HIGH);
                    break;
                }
                case NORMAL: {
                    event.setPriority(Event.PRIORITY_NORMAL);
                    break;
                }
                case LOW: {
                    event.setPriority(Event.PRIORITY_LOW);
                    break;
                }
                default: {
                    event.setPriority(Event.PRIORITY_NONE);
                }
            }
        }
        event.setSummary(task.getTitle());
        String assignee = task.getAssignee();
        if (assignee != null) {
            assignee = encoder.encode(assignee);
        }
        event.setTaskDelegator(assignee);
        return event;
    }
}

