/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.UserSetting;

public class ProjectDto
implements Serializable {
    private static final Log LOG = ExoLogger.getLogger(ProjectDto.class);
    private long id;
    private String name;
    private String description;
    private String color;
    private Set<Status> status;
    private Set<String> manager;
    private Set<String> participator;
    private Date dueDate;
    private Long lastModifiedDate;
    private Project parent;
    private List<Project> children;
    private Set<UserSetting> hiddenOn;
    private String spaceName;

    public ProjectDto(String name, String description, HashSet<Status> statuses, Set<String> managers, Set<String> participators) {
        this.name = name;
        this.description = description;
        this.status = statuses;
        this.manager = managers;
        this.participator = participators;
    }

    public ProjectDto clone(boolean cloneTask) {
        ProjectDto project = new ProjectDto();
        project.setId(this.getId());
        project.setName(this.getName());
        project.setDescription(this.getDescription());
        project.setColor(this.getColor());
        project.setDueDate(this.getDueDate());
        if (this.getParent() != null) {
            project.setParent(this.getParent().clone(false));
        }
        project.status = new HashSet<Status>();
        project.children = new LinkedList<Project>();
        return project;
    }

    public boolean canView(Identity user) {
        HashSet<String> permissions = new HashSet<String>();
        Set<String> Participants = this.getParticipator();
        Set<String> managers = this.getManager();
        if (Participants != null) {
            permissions.addAll(Participants);
        }
        if (managers != null) {
            permissions.addAll(managers);
        }
        return this.hasPermission(user, permissions);
    }

    public boolean canEdit(Identity user) {
        return this.hasPermission(user, this.getManager());
    }

    private boolean hasPermission(Identity user, Set<String> permissions) {
        if (permissions.contains(user.getUserId())) {
            return true;
        }
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        for (String per : permissions) {
            MembershipEntry entry = MembershipEntry.parse((String)per);
            if (entry == null) continue;
            memberships.add(entry);
        }
        for (MembershipEntry entry : user.getMemberships()) {
            if (!memberships.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDto)) {
            return false;
        }
        ProjectDto other = (ProjectDto)obj;
        return this.getId() == other.getId();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public Set<Status> getStatus() {
        return this.status;
    }

    public Set<String> getManager() {
        return this.manager;
    }

    public Set<String> getParticipator() {
        return this.participator;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Project getParent() {
        return this.parent;
    }

    public List<Project> getChildren() {
        return this.children;
    }

    public Set<UserSetting> getHiddenOn() {
        return this.hiddenOn;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setStatus(Set<Status> status) {
        this.status = status;
    }

    public void setManager(Set<String> manager) {
        this.manager = manager;
    }

    public void setParticipator(Set<String> participator) {
        this.participator = participator;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setParent(Project parent) {
        this.parent = parent;
    }

    public void setChildren(List<Project> children) {
        this.children = children;
    }

    public void setHiddenOn(Set<UserSetting> hiddenOn) {
        this.hiddenOn = hiddenOn;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String toString() {
        return "ProjectDto(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", color=" + this.getColor() + ", status=" + this.getStatus() + ", manager=" + this.getManager() + ", participator=" + this.getParticipator() + ", dueDate=" + this.getDueDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", parent=" + this.getParent() + ", children=" + this.getChildren() + ", hiddenOn=" + this.getHiddenOn() + ", spaceName=" + this.getSpaceName() + ")";
    }

    public ProjectDto() {
    }
}

