/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure9;
import org.exoplatform.task.storage.LabelStorage;
import org.exoplatform.task.storage.TaskStorage;

public class LabelServiceImpl
implements LabelService {
    @Inject
    private DAOHandler daoHandler;
    @Inject
    private TaskStorage taskStorage;
    @Inject
    private LabelStorage labelStorage;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public LabelServiceImpl(LabelStorage labelStorage, TaskStorage taskStorage, DAOHandler daoHandler) {
        this.labelStorage = labelStorage;
        this.taskStorage = taskStorage;
        this.daoHandler = daoHandler;
    }

    @Override
    public List<LabelDto> findLabelsByUser(String username, int offset, int limit) {
        return this.labelStorage.findLabelsByUser(username, offset, limit);
    }

    @Override
    public List<LabelDto> findLabelsByTask(long taskId, String username, int offset, int limit) {
        return this.labelStorage.findLabelsByTask(taskId, username, offset, limit);
    }

    @Override
    public LabelDto getLabel(long labelId) {
        return this.labelStorage.labelToDto((Label)this.daoHandler.getLabelHandler().find(Long.valueOf(labelId)));
    }

    @Override
    @ExoTransactional
    public LabelDto createLabel(LabelDto label) {
        LabelDto labelDto = label;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)labelDto);
        Object[] objectArray = new Object[]{this, labelDto, joinPoint};
        return (LabelDto)ExoTransactionalAspect.aspectOf().around(new LabelServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public LabelDto updateLabel(LabelDto label, List<Label.FIELDS> fields) throws EntityNotFoundException {
        LabelDto labelDto = label;
        List<Label.FIELDS> list = fields;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)labelDto, list);
        Object[] objectArray = new Object[]{this, labelDto, list, joinPoint};
        return (LabelDto)ExoTransactionalAspect.aspectOf().around(new LabelServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeLabel(long labelId) {
        long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new LabelServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void addTaskToLabel(TaskDto task, Long labelId) throws EntityNotFoundException {
        TaskDto taskDto = task;
        Long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskDto, (Object)l);
        Object[] objectArray = new Object[]{this, taskDto, l, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new LabelServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTaskFromLabel(TaskDto task, Long labelId) throws EntityNotFoundException {
        TaskDto taskDto = task;
        Long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskDto, (Object)l);
        Object[] objectArray = new Object[]{this, taskDto, l, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new LabelServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        LabelServiceImpl.ajc$preClinit();
    }

    static /* synthetic */ LabelDto createLabel_aroundBody0(LabelServiceImpl ajc$this, LabelDto label, JoinPoint joinPoint) {
        return ajc$this.labelStorage.createLabel(label);
    }

    static /* synthetic */ LabelDto updateLabel_aroundBody2(LabelServiceImpl ajc$this, LabelDto label, List fields, JoinPoint joinPoint) {
        LabelDto lb = ajc$this.getLabel(label.getId());
        if (lb == null) {
            throw new EntityNotFoundException(label.getId(), (Class<?>)LabelDto.class);
        }
        for (Label.FIELDS field : fields) {
            switch (field) {
                case NAME: {
                    lb.setName(label.getName());
                    break;
                }
                case COLOR: {
                    lb.setColor(label.getColor());
                    break;
                }
                case PARENT: {
                    lb.setParent(label.getParent());
                    break;
                }
                case HIDDEN: {
                    lb.setHidden(label.isHidden());
                }
            }
        }
        return ajc$this.labelStorage.labelToDto((Label)ajc$this.daoHandler.getLabelHandler().update(ajc$this.labelStorage.mappingLabelToEntity(lb)));
    }

    static /* synthetic */ void removeLabel_aroundBody4(LabelServiceImpl ajc$this, long labelId, JoinPoint joinPoint) {
        ajc$this.daoHandler.getLabelHandler().delete(ajc$this.labelStorage.labelToEntity(ajc$this.getLabel(labelId)));
    }

    static /* synthetic */ void addTaskToLabel_aroundBody6(LabelServiceImpl ajc$this, TaskDto task, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(ajc$this.labelStorage.mappingLabelToEntity(ajc$this.getLabel(labelId)));
        mapping.setTask(ajc$this.taskStorage.toEntity(task));
        ajc$this.daoHandler.getLabelTaskMappingHandler().create(mapping);
    }

    static /* synthetic */ void removeTaskFromLabel_aroundBody8(LabelServiceImpl ajc$this, TaskDto task, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(ajc$this.labelStorage.mappingLabelToEntity(ajc$this.getLabel(labelId)));
        mapping.setTask(ajc$this.taskStorage.toEntity(task));
        ajc$this.daoHandler.getLabelTaskMappingHandler().delete(mapping);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LabelServiceImpl.java", LabelServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.LabelDto", "label", "", "org.exoplatform.task.dto.LabelDto"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.LabelDto:java.util.List", "label:fields", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.LabelDto"), 63);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "long", "labelId", "", "void"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskToLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.TaskDto:java.lang.Long", "task:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 97);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTaskFromLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.TaskDto:java.lang.Long", "task:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 106);
    }
}

