/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.legacy.service.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.StatusService;
import org.exoplatform.task.legacy.service.TaskService;
import org.exoplatform.task.legacy.service.impl.ProjectServiceImpl$AjcClosure1;
import org.exoplatform.task.legacy.service.impl.ProjectServiceImpl$AjcClosure3;
import org.exoplatform.task.legacy.service.impl.ProjectServiceImpl$AjcClosure5;
import org.exoplatform.task.legacy.service.impl.ProjectServiceImpl$AjcClosure7;
import org.exoplatform.task.legacy.service.impl.ProjectServiceImpl$AjcClosure9;
import org.exoplatform.task.util.ListUtil;

@Singleton
public class ProjectServiceImpl
implements ProjectService {
    private static final Log LOG;
    @Inject
    StatusService statusService;
    @Inject
    TaskService taskService;
    @Inject
    DAOHandler daoHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ProjectServiceImpl() {
    }

    public ProjectServiceImpl(StatusService statusService, TaskService taskService, DAOHandler daoHandler) {
        this.daoHandler = daoHandler;
        this.statusService = statusService;
        this.taskService = taskService;
    }

    @Override
    @ExoTransactional
    public Project createProject(Project project) {
        Project project2 = project;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)project2);
        Object[] objectArray = new Object[]{this, project2, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project createProject(Project project, long parentId) throws EntityNotFoundException {
        Project project2 = project;
        long l = parentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)project2, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, project2, Conversions.longObject((long)l), joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project updateProject(Project proj) {
        Project project = proj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)project);
        Object[] objectArray = new Object[]{this, project, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeProject(long id, boolean deleteChild) throws EntityNotFoundException {
        long l = id;
        boolean bl = deleteChild;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project cloneProject(long id, boolean cloneTask) throws EntityNotFoundException {
        long l = id;
        boolean bl = cloneTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.booleanObject((boolean)bl), joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Project getProject(Long id) throws EntityNotFoundException {
        Project project = (Project)this.daoHandler.getProjectHandler().find(id);
        if (project == null) {
            throw new EntityNotFoundException((long)id, (Class<?>)Project.class);
        }
        return project;
    }

    @Override
    public ListAccess<Project> getSubProjects(long parentId) {
        try {
            Project parent = this.getProject(parentId);
            return this.daoHandler.getProjectHandler().findSubProjects(parent);
        }
        catch (EntityNotFoundException ex) {
            return new ListAccess<Project>(){

                public int getSize() throws Exception {
                    return 0;
                }

                public Project[] load(int arg0, int arg1) throws Exception, IllegalArgumentException {
                    return new Project[0];
                }
            };
        }
    }

    @Override
    public ListAccess<Project> findProjects(ProjectQuery query) {
        return this.daoHandler.getProjectHandler().findProjects(query);
    }

    @Override
    public ListAccess<Project> findProjects(List<String> memberships, String keyword, OrderBy order) {
        return this.daoHandler.getProjectHandler().findAllByMembershipsAndKeyword(memberships, keyword, order);
    }

    @Override
    public Set<String> getManager(long projectId) {
        ProjectQuery query = new ProjectQuery();
        query.setId(projectId);
        List manager = this.daoHandler.getProjectHandler().selectProjectField(query, "manager");
        return new HashSet<String>(manager);
    }

    @Override
    public Set<String> getParticipator(long projectId) {
        ProjectQuery query = new ProjectQuery();
        query.setId(projectId);
        List manager = this.daoHandler.getProjectHandler().selectProjectField(query, "participator");
        return new HashSet<String>(manager);
    }

    static {
        ProjectServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(ProjectServiceImpl.class);
    }

    static /* synthetic */ Project createProject_aroundBody0(ProjectServiceImpl ajc$this, Project project, JoinPoint joinPoint) {
        Project proj = (Project)ajc$this.daoHandler.getProjectHandler().create(project);
        return proj;
    }

    static /* synthetic */ Project createProject_aroundBody2(ProjectServiceImpl ajc$this, Project project, long parentId, JoinPoint joinPoint) {
        Project parentProject = (Project)ajc$this.daoHandler.getProjectHandler().find(Long.valueOf(parentId));
        if (parentProject != null) {
            project.setParent(parentProject);
            project.setParticipator(new HashSet<String>(parentProject.getParticipator()));
            project.setManager(new HashSet<String>(parentProject.getManager()));
            project = ajc$this.createProject(project);
            List<Status> prSt = ajc$this.statusService.getStatuses(parentProject.getId());
            Collections.sort(prSt);
            for (Status st : prSt) {
                ajc$this.statusService.createStatus(project, st.getName());
            }
            return project;
        }
        LOG.info((Object)("Can not find project for parent with ID: " + parentId));
        throw new EntityNotFoundException(parentId, (Class<?>)Project.class);
    }

    static /* synthetic */ Project updateProject_aroundBody4(ProjectServiceImpl ajc$this, Project proj, JoinPoint joinPoint) {
        Project obj = (Project)ajc$this.daoHandler.getProjectHandler().update(proj);
        return obj;
    }

    static /* synthetic */ void removeProject_aroundBody6(ProjectServiceImpl ajc$this, long id, boolean deleteChild, JoinPoint joinPoint) {
        Project project = ajc$this.getProject(id);
        if (project == null) {
            throw new EntityNotFoundException(id, (Class<?>)Project.class);
        }
        ajc$this.daoHandler.getProjectHandler().removeProject(id, deleteChild);
    }

    static /* synthetic */ Project cloneProject_aroundBody8(ProjectServiceImpl ajc$this, long id, boolean cloneTask, JoinPoint joinPoint) {
        Set<String> participators;
        Project project = ajc$this.getProject(id);
        Project newProject = project.clone(cloneTask);
        Set<String> managers = ajc$this.getManager(id);
        if (managers != null && !managers.isEmpty()) {
            newProject.setManager(managers);
        }
        if ((participators = ajc$this.getParticipator(id)) != null && !participators.isEmpty()) {
            newProject.setParticipator(participators);
        }
        newProject.setId(0L);
        newProject.setName("Copy of " + newProject.getName());
        newProject = ajc$this.createProject(newProject);
        List<Status> statuses = ajc$this.statusService.getStatuses(id);
        if (statuses != null) {
            for (Status st : statuses) {
                Status s = ajc$this.statusService.createStatus(newProject, st.getName());
                if (!cloneTask) continue;
                TaskQuery taskQuery = new TaskQuery();
                taskQuery.setStatus(st);
                ListAccess<Task> tasks = ajc$this.taskService.findTasks(taskQuery);
                if (tasks == null) continue;
                for (Task t : ListUtil.load(tasks, 0, -1)) {
                    Task newTask = t.clone();
                    newTask.setId(0L);
                    newTask.setStatus(s);
                    newTask.setCoworker(ajc$this.taskService.getCoworker(t.getId()));
                    newTask.setTitle("Copy of " + newTask.getTitle());
                    ajc$this.taskService.createTask(newTask);
                }
            }
        }
        return newProject;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProjectServiceImpl.java", ProjectServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createProject", "org.exoplatform.task.legacy.service.impl.ProjectServiceImpl", "org.exoplatform.task.domain.Project", "project", "", "org.exoplatform.task.domain.Project"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createProject", "org.exoplatform.task.legacy.service.impl.ProjectServiceImpl", "org.exoplatform.task.domain.Project:long", "project:parentId", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Project"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProject", "org.exoplatform.task.legacy.service.impl.ProjectServiceImpl", "org.exoplatform.task.domain.Project", "proj", "", "org.exoplatform.task.domain.Project"), 111);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeProject", "org.exoplatform.task.legacy.service.impl.ProjectServiceImpl", "long:boolean", "id:deleteChild", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 118);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneProject", "org.exoplatform.task.legacy.service.impl.ProjectServiceImpl", "long:boolean", "id:cloneTask", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Project"), 127);
    }
}

