/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.model.User;
import org.exoplatform.task.model.UserGroup;

public final class UserUtil {
    public static final int SEARCH_LIMIT = 10;

    private UserUtil() {
    }

    public static String getDisplayName(org.exoplatform.services.organization.User user) {
        if (user == null) {
            return "";
        }
        String displayName = user.getDisplayName();
        if (displayName == null) {
            if (user.getFirstName() != null) {
                displayName = user.getFirstName();
            }
            if (user.getLastName() != null) {
                displayName = displayName == null ? user.getLastName() : new StringBuffer(displayName).append(" " + user.getLastName()).toString();
            }
            if (displayName == null) {
                displayName = user.getUserName();
            }
        }
        return displayName;
    }

    public static List<String> getSpaceMemberships(String space_group_id) {
        LinkedList<String> memberships = new LinkedList<String>();
        if (space_group_id == null) {
            throw new IllegalArgumentException("space_group_id is null");
        }
        memberships.add(new MembershipEntry(space_group_id, "manager").toString());
        memberships.add(new MembershipEntry(space_group_id, "member").toString());
        return memberships;
    }

    public static List<String> getMemberships(org.exoplatform.services.security.Identity identity) {
        HashMap gms = new HashMap();
        for (MembershipEntry m : identity.getMemberships()) {
            LinkedList<MembershipEntry> ms = (LinkedList<MembershipEntry>)gms.get(m.getGroup());
            if (ms == null) {
                ms = new LinkedList<MembershipEntry>();
                gms.put(m.getGroup(), ms);
                ms.add(new MembershipEntry(m.getGroup(), "*"));
            }
            if (m.getMembershipType().equals("*")) continue;
            ms.add(m);
        }
        ArrayList<String> memberships = new ArrayList<String>();
        String userName = identity.getUserId();
        memberships.add(userName);
        for (List ms : gms.values()) {
            for (MembershipEntry m : ms) {
                memberships.add(m.toString());
            }
        }
        return memberships;
    }

    public static List<UserGroup> buildGroupTree(Collection<Group> groups) {
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        HashMap<String, UserGroup> temps = new HashMap<String, UserGroup>();
        for (Group g : groups) {
            UserGroup userGroup = new UserGroup(g.getId(), g.getGroupName(), g.getLabel());
            temps.put(g.getId(), userGroup);
        }
        for (Group g : groups) {
            UserGroup ug = (UserGroup)temps.get(g.getId());
            if (g.getParentId() == null || g.getParentId().isEmpty()) {
                userGroups.add(ug);
                continue;
            }
            UserGroup parent = (UserGroup)temps.get(g.getParentId());
            parent.addChild(ug);
        }
        return userGroups;
    }

    public static boolean isPlatformAdmin(org.exoplatform.services.security.Identity identity) {
        UserACL userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        String adminGroup = userACL.getAdminGroups();
        for (MembershipEntry m : identity.getMemberships()) {
            String group = m.getGroup();
            if (!group.equals(adminGroup)) continue;
            return true;
        }
        return false;
    }

    public static User getUser(String userName) {
        if (userName == null) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity id = identityManager.getOrCreateIdentity("organization", userName);
        if (id == null) {
            return null;
        }
        Profile profile = id.getProfile();
        return new User(userName, profile.getEmail(), null, null, profile.getFullName(), profile.getAvatarUrl(), profile.getUrl());
    }
}

