/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.ActivityTaskProcessor;
import org.exoplatform.task.legacy.service.ParserContext;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.StatusService;
import org.exoplatform.task.legacy.service.TaskParser;
import org.exoplatform.task.legacy.service.TaskService;
import org.exoplatform.task.legacy.service.UserService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.StringUtil;

public class ActivityTaskCreationListener
extends ActivityListenerPlugin {
    private TaskService taskService;
    private ProjectService projectService;
    private StatusService statusService;
    private TaskParser parser;
    private final IdentityManager identityManager;
    private final ActivityManager activityManager;
    private final SpaceService spaceService;
    private UserService userService;
    public static final String PREFIX = "++";

    public ActivityTaskCreationListener(TaskService taskServ, ProjectService projectService, StatusService statusService, TaskParser parser, IdentityManager identityManager, ActivityManager activityManager, SpaceService spaceService, UserService userService) {
        this.taskService = taskServ;
        this.projectService = projectService;
        this.statusService = statusService;
        this.parser = parser;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
        this.userService = userService;
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        this.createTask(event, false);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        this.createTask(event, true);
    }

    public void updateComment(ActivityLifeCycleEvent event) {
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
    }

    public void likeComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    private void createTask(ActivityLifeCycleEvent event, boolean isComment) {
        int idx;
        ExoSocialActivity activity = event.getActivity();
        String comment = activity.getTitle();
        if (comment != null && !comment.isEmpty() && (idx = comment.indexOf(PREFIX)) >= 0 && idx + 2 < comment.length() - 1) {
            String spaceName;
            Space space;
            List projects;
            ExoSocialActivity rootActivity = isComment ? this.activityManager.getActivity(activity.getParentId()) : activity;
            Identity identity = this.identityManager.getIdentity(activity.getPosterId(), false);
            ParserContext context = new ParserContext(this.userService.getUserTimezone(identity.getRemoteId()));
            comment = ActivityTaskProcessor.decode(comment);
            comment = StringEscapeUtils.unescapeHtml((String)comment);
            Task taskInfo = this.extractTaskInfo(comment);
            Task task = this.parser.parse(taskInfo.getTitle(), context);
            task.setDescription(StringUtil.encodeInjectedHtmlTag((String)taskInfo.getDescription()));
            task.setContext(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            task.setCreatedBy(identity.getRemoteId());
            task.setActivityId(activity.getId());
            if (rootActivity.getActivityStream().getType() == ActivityStream.Type.SPACE && (projects = ProjectUtil.getProjectTree((String)(space = this.spaceService.getSpaceByPrettyName(spaceName = rootActivity.getActivityStream().getPrettyId())).getGroupId(), (ProjectService)this.projectService)) != null && projects.size() > 0) {
                task.setStatus(this.statusService.getDefaultStatus(((Project)projects.get(0)).getId()));
            }
            this.taskService.createTask(task);
            activity.setTitle(comment);
            this.activityManager.updateActivity(activity);
        }
    }

    Task extractTaskInfo(String html) {
        int idx = html.indexOf(PREFIX);
        String text = html.substring(idx + 2);
        text = text.replaceFirst("<br(\\s*\\/?)>", "\n");
        StringBuilder taskTitle = new StringBuilder();
        String description = "";
        boolean ignore = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (ignore) {
                if (c != '>') continue;
                ignore = false;
                continue;
            }
            if (c == '<') {
                ignore = true;
                continue;
            }
            if (c == '\n') {
                description = text.substring(i).trim();
                break;
            }
            taskTitle.append(c);
        }
        Task task = new Task();
        task.setTitle(taskTitle.toString());
        task.setDescription(description);
        return task;
    }
}

