/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.ArrayList;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure7;

@Singleton
public class UserServiceImpl
implements UserService {
    private static final User GUEST;
    private static final User NULL;
    private static final Log LOG;
    @Inject
    private OrganizationService orgService;
    @Inject
    private IdentityManager identityManager;
    @Inject
    private DAOHandler daoHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public UserServiceImpl(OrganizationService orgService, IdentityManager idMgr, DAOHandler handler) {
        this.orgService = orgService;
        this.identityManager = idMgr;
        this.daoHandler = handler;
    }

    @Override
    public User loadUser(String username) {
        if (username == null || username.isEmpty()) {
            return GUEST;
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", username, true);
        if (identity == null) {
            return GUEST;
        }
        return this.convertToUser(identity);
    }

    @Override
    public ListAccess<User> findUserByName(String keyword) {
        ProfileFilter filter = new ProfileFilter();
        filter.setName(keyword);
        filter.setCompany("");
        filter.setPosition("");
        filter.setSkills("");
        filter.setExcludedIdentityList(new ArrayList());
        final ListAccess list = this.identityManager.getIdentitiesByProfileFilter("organization", filter, true);
        return new ListAccess<User>(){

            public User[] load(int index, int length) throws Exception, IllegalArgumentException {
                org.exoplatform.social.core.identity.model.Identity[] identities = (org.exoplatform.social.core.identity.model.Identity[])list.load(index, length);
                User[] users = new User[identities.length];
                for (int i = 0; i < identities.length; ++i) {
                    org.exoplatform.social.core.identity.model.Identity id = identities[i];
                    users[i] = UserServiceImpl.this.convertToUser(id);
                }
                return users;
            }

            public int getSize() throws Exception {
                return list.getSize();
            }
        };
    }

    private User convertToUser(org.exoplatform.social.core.identity.model.Identity identity) {
        Profile profile = identity.getProfile();
        String username = identity.getRemoteId();
        String email = profile.getEmail();
        String firstName = (String)profile.getProperty("firstName");
        String lastName = (String)profile.getProperty("lastName");
        String displayName = profile.getFullName();
        String avatar = profile.getAvatarUrl();
        if (avatar == null) {
            avatar = "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
        }
        String url = profile.getUrl();
        User u = new User(username, email, firstName, lastName, displayName, avatar, url);
        u.setDeleted(identity.isDeleted());
        u.setEnable(identity.isEnable());
        u.setExternal(identity.getProfile().getProperty("external") != null && identity.getProfile().getProperty("external").equals("true"));
        return u;
    }

    @Override
    @ExoTransactional
    public UserSetting getUserSetting(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        UserServiceImpl$AjcClosure1 userServiceImpl$AjcClosure1 = new UserServiceImpl$AjcClosure1(objectArray);
        return (UserSetting)ExoTransactionalAspect.aspectOf().around(userServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void hideProject(Identity identity, Long projectId, boolean hide) throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        Identity identity2 = identity;
        Long l = projectId;
        boolean bl = hide;
        Object[] objectArray = new Object[]{identity2, l, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity2, l, Conversions.booleanObject((boolean)bl), joinPoint};
        UserServiceImpl$AjcClosure3 userServiceImpl$AjcClosure3 = new UserServiceImpl$AjcClosure3(objectArray2);
        ExoTransactionalAspect.aspectOf().around(userServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void showHiddenProject(String username, boolean show) {
        String string = username;
        boolean bl = show;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, string, Conversions.booleanObject((boolean)bl), joinPoint};
        UserServiceImpl$AjcClosure5 userServiceImpl$AjcClosure5 = new UserServiceImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(userServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void showHiddenLabel(String username, boolean show) {
        String string = username;
        boolean bl = show;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, string, Conversions.booleanObject((boolean)bl), joinPoint};
        UserServiceImpl$AjcClosure7 userServiceImpl$AjcClosure7 = new UserServiceImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(userServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    public TimeZone getUserTimezone(String username) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", username, false);
        if (userIdentity == null || userIdentity.getProfile().getTimeZone() == null) {
            return TimeZone.getDefault();
        }
        String timeZoneId = userIdentity.getProfile().getTimeZone();
        return TimeZone.getTimeZone(timeZoneId);
    }

    static {
        UserServiceImpl.ajc$preClinit();
        GUEST = new User("guest", null, "", "", "Guest", "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png", "#");
        NULL = new User(null, null, "", "", "Guest", "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png", "#");
        LOG = ExoLogger.getExoLogger(UserServiceImpl.class);
    }

    static /* synthetic */ UserSetting getUserSetting_aroundBody0(UserServiceImpl ajc$this, String username, JoinPoint joinPoint) {
        return ajc$this.daoHandler.getUserSettingHandler().getOrCreate(username);
    }

    static /* synthetic */ void hideProject_aroundBody2(UserServiceImpl ajc$this, Identity identity, Long projectId, boolean hide, JoinPoint joinPoint) {
        Project project = (Project)ajc$this.daoHandler.getProjectHandler().find(projectId);
        if (project == null) {
            throw new EntityNotFoundException((long)projectId, (Class<?>)Project.class);
        }
        if (!project.canView(identity)) {
            throw new NotAllowedOperationOnEntityException(projectId, Project.class, "hide");
        }
        UserSetting setting = ajc$this.daoHandler.getUserSettingHandler().getOrCreate(identity.getUserId());
        if (hide) {
            setting.getHiddenProjects().add(project);
        } else {
            setting.getHiddenProjects().remove(project);
        }
        ajc$this.daoHandler.getUserSettingHandler().update(setting);
    }

    static /* synthetic */ void showHiddenProject_aroundBody4(UserServiceImpl ajc$this, String username, boolean show, JoinPoint joinPoint) {
        UserSetting setting = ajc$this.daoHandler.getUserSettingHandler().getOrCreate(username);
        setting.setShowHiddenProject(show);
        ajc$this.daoHandler.getUserSettingHandler().update(setting);
    }

    static /* synthetic */ void showHiddenLabel_aroundBody6(UserServiceImpl ajc$this, String username, boolean show, JoinPoint joinPoint) {
        UserSetting setting = ajc$this.daoHandler.getUserSettingHandler().getOrCreate(username);
        setting.setShowHiddenLabel(show);
        ajc$this.daoHandler.getUserSettingHandler().update(setting);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserServiceImpl.java", UserServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSetting", "org.exoplatform.task.service.impl.UserServiceImpl", "java.lang.String", "username", "", "org.exoplatform.task.domain.UserSetting"), 141);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hideProject", "org.exoplatform.task.service.impl.UserServiceImpl", "org.exoplatform.services.security.Identity:java.lang.Long:boolean", "identity:projectId:hide", "org.exoplatform.task.exception.EntityNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "void"), 147);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showHiddenProject", "org.exoplatform.task.service.impl.UserServiceImpl", "java.lang.String:boolean", "username:show", "", "void"), 169);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showHiddenLabel", "org.exoplatform.task.service.impl.UserServiceImpl", "java.lang.String:boolean", "username:show", "", "void"), 177);
    }
}

