/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.controller.router.Router;

public class ActivityTaskProcessor
extends BaseActivityProcessorPlugin {
    private final TaskService taskService;
    private final EntityManagerService entityManagerService;
    private final WebAppController webAppController;

    public ActivityTaskProcessor(InitParams params, WebAppController controller, TaskService taskServ, EntityManagerService entityManagerService) {
        super(params);
        this.entityManagerService = entityManagerService;
        this.taskService = taskServ;
        this.webAppController = controller;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            activity.setTitle(this.substituteTask(activity.getTitle(), activity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substituteTask(String message, ExoSocialActivity activity) {
        if (message == null) {
            return null;
        }
        int idx = message.indexOf("++");
        if (idx >= 0) {
            try {
                RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
                TaskDto task = this.taskService.findTaskByActivityId(activity.getId());
                if (task != null) {
                    RequestContext request = RequestContext.getCurrentInstance();
                    String portalName = "intranet";
                    if (request != null) {
                        PortalRequestContext pContext = (PortalRequestContext)RequestContext.getCurrentInstance().getParentAppRequestContext();
                        portalName = pContext.getPortalOwner();
                    }
                    String taskURL = TaskUtil.buildTaskURL((TaskDto)task, (SiteKey)SiteKey.portal((String)portalName), (ExoContainer)ExoContainerContext.getCurrentContainer(), (Router)this.webAppController.getRouter());
                    String string = this.substituteTask(taskURL, message);
                    return string;
                }
                String string = ActivityTaskProcessor.encode(message);
                return string;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        return message;
    }

    public static String encode(String message) {
        if (message != null && !message.isEmpty()) {
            message = message.replaceAll("@", "{@}");
        }
        return message;
    }

    public static String decode(String message) {
        if (message != null && !message.isEmpty()) {
            message = message.replaceAll("\\{@\\}", "@");
        }
        return message;
    }

    String substituteTask(String taskURL, String html) {
        int idx = html.indexOf("++");
        if (idx == -1) {
            return html;
        }
        StringBuilder builder = new StringBuilder(html);
        String url = "<a href=\"" + taskURL + "\">";
        builder.insert(idx, url);
        int breakIdx = html.indexOf("<", idx);
        if (breakIdx > 0) {
            builder.insert(breakIdx += url.length(), "</a>");
        } else {
            builder.append("</a>");
        }
        return builder.toString();
    }
}

