/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dao.condition.SingleCondition;
import org.exoplatform.task.dao.jpa.CommonJPADAO;
import org.exoplatform.task.dao.jpa.JPAQueryListAccess;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;

public class ProjectDAOImpl
extends CommonJPADAO<Project, Long>
implements ProjectHandler {
    private static final Logger LOG = Logger.getLogger("ProjectDAOImpl");

    public Project update(Project entity) {
        return this.cloneEntity((Project)super.update((Object)entity));
    }

    public void delete(Project entity) {
        Project p = (Project)this.getEntityManager().find(Project.class, (Object)entity.getId());
        if (p != null) {
            super.delete((Object)p);
        }
    }

    @Override
    public Project removeProject(long projectId, boolean deleteChild) {
        Project p = (Project)this.getEntityManager().find(Project.class, (Object)projectId);
        if (p == null) {
            return null;
        }
        if (!deleteChild && p.getChildren() != null) {
            for (Project pj : p.getChildren()) {
                pj.setParent(p.getParent());
                this.getEntityManager().persist((Object)pj);
            }
            p.getChildren().clear();
        }
        if (p.getHiddenOn() != null) {
            for (UserSetting u : p.getHiddenOn()) {
                u.getHiddenProjects().remove(p);
                this.getEntityManager().persist((Object)u);
            }
        }
        super.delete((Object)p);
        return p;
    }

    @Override
    public ListAccess<Project> findSubProjects(Project project) {
        ProjectQuery query = new ProjectQuery();
        if (project != null) {
            query.setParent(project.getId());
        } else {
            query.setParent(null);
        }
        return this.findProjects(query);
    }

    @Override
    public ListAccess<Project> findAllByMembershipsAndKeyword(List<String> memberships, String keyword, OrderBy order) {
        if (order == null && (StringUtils.isBlank((String)keyword) || !keyword.trim().contains(" "))) {
            TypedQuery selectQuery = null;
            TypedQuery countQuery = null;
            if ((memberships == null || memberships.isEmpty()) && StringUtils.isBlank((String)keyword)) {
                selectQuery = this.getEntityManager().createNamedQuery("TaskProject.findAllProjects", Project.class);
                countQuery = this.getEntityManager().createNamedQuery("TaskProject.countAllProjects", Long.class);
            } else if (memberships == null || memberships.isEmpty()) {
                selectQuery = this.getEntityManager().createNamedQuery("TaskProject.findProjectsByKeyword", Project.class);
                selectQuery.setParameter("name", (Object)keyword);
                countQuery = this.getEntityManager().createNamedQuery("TaskProject.countProjectsByKeyword", Long.class);
                countQuery.setParameter("name", (Object)keyword);
            } else if (StringUtils.isBlank((String)keyword)) {
                HashSet<String> membershipsSet = new HashSet<String>(memberships);
                selectQuery = this.getEntityManager().createNamedQuery("TaskProject.findProjectsByMemberships", Project.class);
                selectQuery.setParameter("memberships", membershipsSet);
                countQuery = this.getEntityManager().createNamedQuery("TaskProject.countProjectsByMemberships", Long.class);
                countQuery.setParameter("memberships", membershipsSet);
            } else {
                HashSet<String> membershipsSet = new HashSet<String>(memberships);
                selectQuery = this.getEntityManager().createNamedQuery("TaskProject.findProjectsByMembershipsByKeyword", Project.class);
                selectQuery.setParameter("memberships", membershipsSet);
                selectQuery.setParameter("name", (Object)keyword);
                countQuery = this.getEntityManager().createNamedQuery("TaskProject.countProjectsByMembershipsByKeyword", Long.class);
                countQuery.setParameter("memberships", membershipsSet);
                countQuery.setParameter("name", (Object)keyword);
            }
            return new JPAQueryListAccess<Project>(Project.class, (TypedQuery<Long>)countQuery, selectQuery);
        }
        ProjectQuery query = new ProjectQuery();
        query.setMembership(memberships);
        query.setKeyword(keyword);
        if (order != null) {
            query.setOrderBy(Arrays.asList(order));
        }
        return this.findProjects(query);
    }

    @Override
    public ListAccess<Project> findProjects(ProjectQuery query) {
        return this.findEntities(query, Project.class);
    }

    @Override
    protected Path buildPath(SingleCondition condition, Root<Project> root) {
        String field = condition.getField();
        if ("manager".equals(field) || "participator".equals(field)) {
            return root.join(field, JoinType.LEFT);
        }
        return super.buildPath(condition, root);
    }

    @Override
    public List<Project> findCollaboratedProjects(String userName, String keyword, int offset, int limit) {
        List ids;
        Query q = this.getEntityManager().createNativeQuery("SELECT DISTINCT(p.PROJECT_ID) FROM TASK_PROJECTS p \nwhere \nlower(p.NAME) LIKE lower(concat('%', :keyword, '%'))\nAND\n(p.PROJECT_ID in (\nSELECT distinct(ts.PROJECT_ID)\nFROM TASK_STATUS AS ts\nWHERE ts.STATUS_ID IN\n   ( \nSELECT task.STATUS_ID\nFROM TASK_TASKS AS task\nWHERE task.COMPLETED = false\nAND (task.ASSIGNEE = :userName\n  OR task.TASK_ID IN (\nSELECT com.TASK_ID\nFROM TASK_COMMENTS AS com\nWHERE com.TASK_ID = task.TASK_ID\nAND (com.AUTHOR = :userName\n OR com.COMMENT_ID IN (\nSELECT cmention.COMMENT_ID\nFROM TASK_COMMENT_MENTIONED_USERS AS cmention\nWHERE com.COMMENT_ID = cmention.COMMENT_ID\nAND cmention.MENTIONED_USERS = :userName\n)\n)\n )\n         OR task.TASK_ID IN (\nSELECT coworker.TASK_ID\n            FROM TASK_TASK_COWORKERS AS coworker\n            WHERE coworker.TASK_ID = task.TASK_ID\n AND coworker.COWORKER = :userName\n         )\n    )\n )\n))");
        q.setParameter("keyword", (Object)keyword);
        q.setParameter("userName", (Object)userName);
        if (limit > 0) {
            q.setFirstResult(offset).setMaxResults(limit);
        }
        if ((ids = q.getResultList()).isEmpty()) {
            return new ArrayList<Project>();
        }
        List<Long> idsLong = ids.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toList());
        return this.findIdentitiesByIDs(idsLong);
    }

    @Override
    public List<Project> findNotEmptyProjects(List<String> memberships, String keyword, int offset, int limit) {
        List ids;
        Query q = this.getEntityManager().createNativeQuery("SELECT DISTINCT(p.PROJECT_ID) FROM TASK_PROJECTS p \nwhere \nlower(p.NAME) LIKE lower(concat('%', :keyword , '%'))\nAND\n(p.PROJECT_ID in (\nSELECT man.PROJECT_ID\n            FROM TASK_PROJECT_MANAGERS AS man\n            WHERE man.MANAGER IN (:memberships) \t\t    \n) or \np.PROJECT_ID in (\nSELECT part.PROJECT_ID\n            FROM TASK_PROJECT_PARTICIPATORS AS part\n            WHERE part.PARTICIPATOR IN (:memberships) \n) ) AND p.PROJECT_ID in (\nSELECT distinct(ts.PROJECT_ID)\nFROM TASK_STATUS AS ts\nWHERE ts.STATUS_ID IN(\nSELECT tcol.STATUS_ID FROM  \n(SELECT task.STATUS_ID AS STATUS_ID , COUNT(*) \nFROM TASK_TASKS AS task \nWHERE task.COMPLETED = false\nGROUP BY task.STATUS_ID\nHAVING COUNT(*)> 0) AS tcol\n) \n)\n");
        q.setParameter("keyword", (Object)keyword);
        q.setParameter("memberships", memberships);
        if (limit > 0) {
            q.setFirstResult(offset).setMaxResults(limit);
        }
        if ((ids = q.getResultList()).isEmpty()) {
            return new ArrayList<Project>();
        }
        List<Long> idsLong = ids.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toList());
        return this.findIdentitiesByIDs(idsLong);
    }

    @Override
    public int countCollaboratedProjects(String userName, String keyword) {
        Query q = this.getEntityManager().createNativeQuery("SELECT DISTINCT(p.PROJECT_ID) FROM TASK_PROJECTS p \nwhere \nlower(p.NAME) LIKE lower(concat('%', :keyword, '%'))\nAND\n(p.PROJECT_ID in (\nSELECT distinct(ts.PROJECT_ID)\nFROM TASK_STATUS AS ts\nWHERE ts.STATUS_ID IN\n   ( \nSELECT task.STATUS_ID\nFROM TASK_TASKS AS task\nWHERE task.COMPLETED = false\nAND (task.ASSIGNEE = :userName\n  OR task.TASK_ID IN (\nSELECT com.TASK_ID\nFROM TASK_COMMENTS AS com\nWHERE com.TASK_ID = task.TASK_ID\nAND (com.AUTHOR = :userName\n OR com.COMMENT_ID IN (\nSELECT cmention.COMMENT_ID\nFROM TASK_COMMENT_MENTIONED_USERS AS cmention\nWHERE com.COMMENT_ID = cmention.COMMENT_ID\nAND cmention.MENTIONED_USERS = :userName\n)\n)\n )\n         OR task.TASK_ID IN (\nSELECT coworker.TASK_ID\n            FROM TASK_TASK_COWORKERS AS coworker\n            WHERE coworker.TASK_ID = task.TASK_ID\n AND coworker.COWORKER = :userName\n         )\n    )\n )\n))");
        q.setParameter("keyword", (Object)keyword);
        q.setParameter("userName", (Object)userName);
        int result = Integer.parseInt(q.getSingleResult().toString());
        return result;
    }

    @Override
    public int countNotEmptyProjects(List<String> memberships, String keyword) {
        Query q = this.getEntityManager().createNativeQuery("SELECT DISTINCT(p.PROJECT_ID) FROM TASK_PROJECTS p \nwhere \nlower(p.NAME) LIKE lower(concat('%', :keyword , '%'))\nAND\n(p.PROJECT_ID in (\nSELECT man.PROJECT_ID\n            FROM TASK_PROJECT_MANAGERS AS man\n            WHERE man.MANAGER IN (:memberships) \t\t    \n) or \np.PROJECT_ID in (\nSELECT part.PROJECT_ID\n            FROM TASK_PROJECT_PARTICIPATORS AS part\n            WHERE part.PARTICIPATOR IN (:memberships) \n) ) AND p.PROJECT_ID in (\nSELECT distinct(ts.PROJECT_ID)\nFROM TASK_STATUS AS ts\nWHERE ts.STATUS_ID IN(\nSELECT tcol.STATUS_ID FROM  \n(SELECT task.STATUS_ID AS STATUS_ID , COUNT(*) \nFROM TASK_TASKS AS task \nWHERE task.COMPLETED = false\nGROUP BY task.STATUS_ID\nHAVING COUNT(*)> 0) AS tcol\n) \n)\n");
        q.setParameter("keyword", (Object)keyword);
        q.setParameter("memberships", memberships);
        int result = Integer.parseInt(q.getSingleResult().toString());
        return result;
    }

    protected List<Project> findIdentitiesByIDs(List<Long> ids) {
        TypedQuery query = this.getEntityManager().createNamedQuery("TaskProject.findProjectsByIDs", Project.class);
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    @Override
    public <T> List<T> selectProjectField(ProjectQuery query, String fieldName) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery();
        Root project = q.from(Project.class);
        Predicate predicate = this.buildQuery(query.getCondition(), project, cb, q);
        if (predicate != null) {
            q.where((Expression)predicate);
        }
        q.select((Selection)project.join(fieldName)).distinct(true);
        TypedQuery selectQuery = em.createQuery(q);
        return this.cloneEntities(selectQuery.getResultList());
    }
}

