/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.gamification;

import java.util.HashMap;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskService;

public class GamificationTaskCommentListener
extends Listener<TaskService, CommentDto> {
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationTaskCommentListener(IdentityManager identityManager, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<TaskService, CommentDto> event) throws Exception {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        TaskDto task = ((CommentDto)event.getData()).getTask();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        long projectId = task.getStatus() == null || task.getStatus().getProject() == null ? 0L : task.getStatus().getProject().getId();
        HashMap<String, Object> gam = new HashMap<String, Object>();
        gam.put("eventId", "commentTask");
        gam.put("objectId", String.valueOf(task.getId()));
        gam.put("objectType", "task");
        gam.put("senderId", actorId);
        gam.put("receiverId", actorId);
        if (projectId > 0L) {
            gam.put("eventDetails", "{projectId: " + projectId + "}");
        }
        String gamificationEventName = event.getEventName().equals("exo.task.taskCommentDeletion") ? "gamification.delete.event.action" : "exo.gamification.generic.action";
        this.listenerService.broadcast(gamificationEventName, gam, (Object)String.valueOf(task.getId()));
    }
}

