import './initComponents.js';

Vue.directive('custom-click-outside', {
    bind: function (el, binding, vnode) {
        window.event = function (event) {
            if (!(el === event.target || el.contains(event.target))) {
                vnode.context[binding.expression](event);
            }
        };
        document.body.addEventListener('click', window.event);
    },
    unbind: function (el) {
        document.body.removeEventListener('click', window.event);
    }
});

// get overrided components if exists
if (extensionRegistry) {
    const components = extensionRegistry.loadComponents('TaskDrawer');
    if (components && components.length > 0) {
        components.forEach(cmp => {
            Vue.component(cmp.componentName, cmp.componentOptions);
    });
    }
}

Vue.use(Vuetify);